/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard.ext;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.List;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUtil;
import jaxx.runtime.swing.wizard.ext.WizardExtModel;
import jaxx.runtime.swing.wizard.ext.WizardExtStep;
import jaxx.runtime.swing.wizard.ext.WizardExtUI;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WizardExtUtil
extends WizardUtil {
    private static Log log = LogFactory.getLog(WizardUI.class);

    protected WizardExtUtil() {
    }

    public static boolean acceptStates(WizardState state, WizardState ... accepted) {
        for (WizardState s : accepted) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public static boolean rejectStates(WizardState state, WizardState ... rejected) {
        for (WizardState s : rejected) {
            if (s != state) continue;
            return false;
        }
        return true;
    }

    public static <E extends WizardExtStep, M extends WizardExtModel<E>> void installWizardUIListeners(final WizardExtUI<E, M> ui) {
        PropertyChangeListener dispatcher = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("wasStarted".equals(propertyName)) {
                    ui.onWasStarted();
                    return;
                }
                WizardExtModel model = (WizardExtModel)evt.getSource();
                if ("steps".equals(propertyName)) {
                    List steps = (List)evt.getNewValue();
                    ui.onStepsChanged(steps.toArray((WizardExtStep[])Array.newInstance(model.getStepClass(), steps.size())));
                    return;
                }
                if ("step".equals(propertyName)) {
                    ui.onStepChanged((WizardExtStep)evt.getNewValue());
                    return;
                }
                if ("validStep".equals(propertyName)) {
                    Boolean value = (Boolean)evt.getNewValue();
                    if (value == null || !value.booleanValue()) {
                        ui.onModelStateChanged(WizardState.NEED_FIX);
                    } else {
                        ui.onModelStateChanged(WizardState.PENDING);
                    }
                    return;
                }
                if ("modelState".equals(propertyName)) {
                    ui.onModelStateChanged((WizardState)((Object)evt.getNewValue()));
                    return;
                }
                if ("stepState".equals(propertyName)) {
                    IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent)evt;
                    int stepIndex = e.getIndex();
                    WizardExtStep step = (WizardExtStep)model.getSteps().get(stepIndex);
                    ui.onOperationStateChanged(step, (WizardState)((Object)evt.getNewValue()));
                }
            }
        };
        WizardExtModel model = (WizardExtModel)ui.getModel();
        log.info((Object)("Adding dispatcher " + dispatcher + " to model " + model));
        model.addPropertyChangeListener(dispatcher);
    }
}

