/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJAXXContext
implements JAXXContext {
    protected static final JAXXContextEntryDef<JAXXContext> PARENT_CONTEXT_ENTRY = Util.newContextEntryDef(JAXXContext.class);
    private static final Log log = LogFactory.getLog(DefaultJAXXContext.class);
    protected JAXXContext parentContext;
    protected final Map<JAXXContextEntryDef<?>, Object> data = new HashMap();

    @Override
    public <T> void setContextValue(T o) {
        this.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        if (name == null && PARENT_CONTEXT_ENTRY.accept2(o.getClass(), null)) {
            this.setParentContext((JAXXContext)o);
            return;
        }
        JAXXContextEntryDef<?> entry = this.getKey(name, o.getClass());
        Object oldValue = this.remove0(o.getClass(), name);
        if (oldValue != null && log.isDebugEnabled()) {
            log.debug((Object)("remove value " + oldValue.getClass() + " for " + entry));
        }
        this.data.put(entry, o);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return this.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        if (this.parentContext != null && this.parentContext.getClass() == clazz || PARENT_CONTEXT_ENTRY.accept(clazz, name)) {
            return (T)this.getParentContext();
        }
        for (Map.Entry<JAXXContextEntryDef<?>, Object> entry : this.data.entrySet()) {
            if (!entry.getKey().accept(clazz, name)) continue;
            return (T)entry.getValue();
        }
        if (JAXXContext.class == clazz) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        return parent.getContextValue(clazz, name);
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz) {
        this.removeContextValue(klazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz, String name) {
        this.remove0(klazz, name);
    }

    public String[] getKeys(Class<?> klass) {
        ArrayList<String> keys = new ArrayList<String>();
        for (JAXXContextEntryDef<?> key : this.data.keySet()) {
            if (key.getKlass() != klass) continue;
            keys.add(key.getName());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public void clear() {
        this.data.clear();
    }

    protected JAXXContextEntryDef<?> getKey(String name, Class<?> klass) {
        return Util.newContextEntryDef(name, klass);
    }

    protected <T> T remove0(Class<T> klazz, String name) {
        if (PARENT_CONTEXT_ENTRY.accept(klazz, name)) {
            JAXXContext old = this.getParentContext();
            this.setParentContext(null);
            return (T)old;
        }
        JAXXContextEntryDef<T> entry = null;
        for (JAXXContextEntryDef<T> jAXXContextEntryDef : this.data.keySet()) {
            if (!jAXXContextEntryDef.accept(klazz, name)) continue;
            entry = jAXXContextEntryDef;
            break;
        }
        if (entry != null) {
            return (T)this.data.remove(entry);
        }
        if (JAXXContext.class == klazz) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        if (parent instanceof DefaultJAXXContext) {
            return ((DefaultJAXXContext)parent).remove0(klazz, name);
        }
        return null;
    }

    protected JAXXContext getParentContext() {
        return this.parentContext;
    }

    protected void setParentContext(JAXXContext parentContext) {
        if (parentContext instanceof JAXXObject) {
            parentContext = ((JAXXObject)parentContext).getDelegateContext();
        }
        this.parentContext = parentContext;
    }
}

