package jaxx.runtime.validator;

/**
 * The definition of an event on {@link BeanValidatorListener}
 * to be fired by a {@link BeanValidator}.
 *
 * @author chemit
 * @since 1.3
 */
public class BeanValidatorEvent extends java.util.EventObject {

    private static final long serialVersionUID = 1L;
    /** the field impacted by the validator */
    BeanValidatorField<?> field;
    /** the scope impacted by the event */
    BeanValidatorScope scope;
    String[] messagestoAdd;
    String[] messagestoDelete;

    public BeanValidatorEvent(BeanValidator source, BeanValidatorField<?> field, BeanValidatorScope scope, String[] toAdd, String[] toDelete) {
        super(source);
        this.field = field;
        this.scope = scope;
        this.messagestoAdd = toAdd;
        this.messagestoDelete = toDelete;
    }

    @Override
    public BeanValidator getSource() {
        return (BeanValidator) super.getSource();
    }

    public String getFieldName() {
        return field.getName();
    }

    public String[] getMessagesToAdd() {
        return messagestoAdd;
    }

    public String[] getMessagesToDelete() {
        return messagestoDelete;
    }

    public BeanValidatorScope getScope() {
        return scope;
    }

    public BeanValidatorField getField() {
        return field;
    }
}
