/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.css;

public class Selector implements java.io.Serializable, Comparable<Selector> {
    public static final int NEVER_APPLIES = 0;
    public static final int PSEUDOCLASS_APPLIES_INHERIT_ONLY = 1;
    public static final int PSEUDOCLASS_APPLIES = 2;
    public static final int ALWAYS_APPLIES_INHERIT_ONLY = 3;
    public static final int ALWAYS_APPLIES = 4;

    private String javaClassName;
    private String styleClass;
    private String pseudoClass;
    private String id;
    private boolean inline;
    private static final long serialVersionUID = 1L;


    public Selector(String javaClassName, String styleClass, String pseudoClass, String id) {
        this(javaClassName, styleClass, pseudoClass, id, false);
    }


    public Selector(String javaClassName, String styleClass, String pseudoClass, String id, boolean inline) {
        this.javaClassName = javaClassName;
        this.styleClass = styleClass;
        this.pseudoClass = pseudoClass;
        this.id = id;
        this.inline = inline;
    }


    public String getJavaClassName() {
        return javaClassName;
    }


    public String getStyleClass() {
        return styleClass;
    }


    public String getPseudoClass() {
        return pseudoClass;
    }


    public String getId() {
        return id;
    }


    public boolean isInline() {
        return inline;
    }

    @Override
    public int compareTo(Selector selector) {
        if (inline && !selector.inline) {
            return 1;
        }
        if (!inline && selector.inline) {
            return -1;
        }
        if (pseudoClass != null && selector.pseudoClass == null) {
            return 1;
        }
        if (pseudoClass == null && selector.pseudoClass != null) {
            return -1;
        }
        if (id != null && selector.id == null) {
            return 1;
        }
        if (id == null && selector.id != null) {
            return -1;
        }
        if (styleClass != null && selector.styleClass == null) {
            return 1;
        }
        if (styleClass == null && selector.styleClass != null) {
            return -1;
        }
        if (javaClassName != null && selector.javaClassName == null) {
            return 1;
        }
        if (javaClassName == null && selector.javaClassName != null) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Selector[" + javaClassName + ", " + styleClass + ", " + pseudoClass + ", " + id + "]";
    }
}