/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


/**
 * A <code>PropertyChangeListener</code> which removes and re-applies a data binding
 * when it receives a <code>PropertyChangeEvent</code>.
 */
public class DataBindingUpdateListener implements PropertyChangeListener {
    private JAXXObject object;
    private String dest;

    /**
     * Creates a new <code>DataBindingUpdateListener</code> which will remove and re-apply a
     * data binding when it receives a <code>PropertyChangeEvent</code>.
     *
     * @param object the object in which the data binding exists
     * @param dest   the name of the data binding to reapply
     */
    public DataBindingUpdateListener(JAXXObject object, String dest) {
        this.object = object;
        this.dest = dest;
    }


    public String getBindingName() {
        return dest;
    }


    /**
     * Updates the data binding in response to a <code>PropertyChangeEvent</code>.
     *
     * @param e the event which triggered the binding
     */
    public void propertyChange(PropertyChangeEvent e) {
        object.removeDataBinding(dest);
        object.applyDataBinding(dest);
    }
}