package org.nuiton.jaxx.demo.fun;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.VBox;
import static org.nuiton.i18n.I18n.t;

public class LabelStyleDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL5_FONT_SIZE = "$JLabel5.font-size";
    private static final String BINDING_$JLABEL5_FOREGROUND = "$JLabel5.foreground";
    private static final String BINDING_$JLABEL5_TEXT = "$JLabel5.text";
    private static final String BINDING_$VBOX0_BACKGROUND = "$VBox0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz2/cRBTHJ9vsJpuUpN2oVVUkFJEtqWjrTZO0EiQqbRIFiBaCum0pRCDG68nuJLbHjMeJ00MPHLjxD3DolQvq/1BxQuLCNfwNSP0TeDPr/RW846EmB2c9fu/j7/eN/Z5//RsVQ45uMt6y/IgK5lsHOI4tHvmCesTaefD06a59QJpii4RNTgPBOOr8jRVQYQ9NO731UCBrrw6kWodUk6RaQqptMi9gPvEHQGt1NBWKE5eEbUKEQNdHJjfDsNboRa7FQcSTe6WqTrvXHz/ePh0jWz8XEIoDkH8VbN/4D4C+6/E6KlBHoEr9AB/hmov9Fojj1G+Bobfk2qaLw/Bz7JHv0XM0UUelAHOACXTrjcqjcAoVBwJNV7eIx77APnGXBFo8a8GBi9Z+5Ft1bBNXFU3GB4EilAQqO910gRZGFSA8BjvWI2y7ykO5lz1RVYtL8nRGHs73Lk1Wd9Q9QVVFViFOKJ1VGTTbix0XJIZ6XB6KewRr25S4znBsl3tbns8NXzvHCezE3BCm4VKHcBUnULHJXHg0z6CWU1DFFifElydva3NXUnLHbTci2amrKallJ/K8kwZ9NpA/aL270cMlVavDsaXqkw0WQ+S7+k2VUTLlxr8KfKcnzzpDVaVfGt7uio2bhy3OIt/ZbJPmoc1igS4NqVTrye1Weokz1Z2H2KFsIxIgEQRfGUoauKbLU5I+1EUsZ0asZEasZkbcyYy4mxIxO1A8+aRAa9DvmmzEHdzHkBXA68zRe6NSoF1a/XbZ71xje6jII1iGN390p5bN9iFEddrswug2K2+jAn94+Zz/cvz6tNtbV0DcfFbWwBiBRhdwFhAuqNQ222mskaBu7TMcrO2hckhcmEFqxizqlTeSSFAPKi5KkiVJ1ic4bAOtOHH66rfL3/15DhW20ZTLsLONZfynqCzaHCrGXCcOPrqvxJ0/noTjBSkTXgUXnzDYAjSz7mCB523qO7A192Ko0qK+Sj1RL3df//7ip2uvupUaA41Vk8x+tYpfoxL1XeoTNYeSEZM6d6aDkEQO68+PtIkyJv9PBcmA2FXHRpr/pGdX1jt3n8cChp4dCQIVkElfKj/y11eKWclkyuVv5OHbdMKl3IQrBr4mPBxTL/I0mKsGmOIRTobAG0Oy3LxjRDjUEOaNCEFugs7FQm4X13K7MCPoXFzP7eJ9o2eT+hnPZjYmqxgmQko248lX1ZN0yk0TSpvQVltotGRT5PLjnDqm+uNXQ6oZkObajNNnzBfYfeDSlu/BJ7zGngmy5GHeon5OysUjOU6b/5+s8j64vBUmH6ojSrZsUvx9xklm8bNJvTc0F+GFhrBq8oaGAW7CZ4CmutmYrGZz10DItN3/PNSgPjBATXY+t4iTi5NlyowQaPbHjPCXRsN6bhdmBJ0LM4LOxb3cLswIOhdmBJ2L+7ldmBF0LswIOhcbuV2YEXQuzAg6F1u5XZgRdC7MCDoX27ldmBF0LiThH7BO5ytmFQAA";
    private static final Log log = LogFactory.getLog(LabelStyleDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox backgroundCheckbox;
    protected JAXXButtonGroup backgroundColor;
    protected JSlider blue;
    protected Table demoPanel;
    protected JSlider dummySize;
    protected JSlider green;
    protected JSlider red;
    protected JTextField text;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LabelStyleDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private JRadioButton $JRadioButton2;
    private JRadioButton $JRadioButton3;
    private JRadioButton $JRadioButton4;
    private JRadioButton $JRadioButton5;
    private JRadioButton $JRadioButton6;
    private Table $Table0;
    private VBox $VBox0;
    private VBox $VBox1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LabelStyleDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LabelStyleDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LabelStyleDemo() {
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public LabelStyleDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getBackgroundCheckbox() {
        return backgroundCheckbox;
    }

    public JAXXButtonGroup getBackgroundColor() {
        return backgroundColor;
    }

    public JSlider getBlue() {
        return blue;
    }

    public Table getDemoPanel() {
        return demoPanel;
    }

    public JSlider getDummySize() {
        return dummySize;
    }

    public JSlider getGreen() {
        return green;
    }

    public JSlider getRed() {
        return red;
    }

    public JTextField getText() {
        return text;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected JRadioButton get$JRadioButton3() {
        return $JRadioButton3;
    }

    protected JRadioButton get$JRadioButton4() {
        return $JRadioButton4;
    }

    protected JRadioButton get$JRadioButton5() {
        return $JRadioButton5;
    }

    protected JRadioButton get$JRadioButton6() {
        return $JRadioButton6;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    protected VBox get$VBox1() {
        return $VBox1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemoPanel() {
        demoPanel.add($Table0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 3, 0, 0), 0, 0));
        demoPanel.add($VBox1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBackgroundCheckbox() {
        $objectMap.put("backgroundCheckbox", backgroundCheckbox = new JCheckBox());
        
        backgroundCheckbox.setName("backgroundCheckbox");
        backgroundCheckbox.setText(t("Show Background"));
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = new JAXXButtonGroup());
    }

    protected void createBlue() {
        $objectMap.put("blue", blue = new JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(255);
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new Table());
        
        demoPanel.setName("demoPanel");
    }

    protected void createDummySize() {
        $objectMap.put("dummySize", dummySize = new JSlider());
        
        dummySize.setName("dummySize");
        dummySize.setValue(0);
        dummySize.setMaximum(60);
        dummySize.setMinimum(6);
        dummySize.setValue(36);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(0);
    }

    protected void createRed() {
        $objectMap.put("red", red = new JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(128);
    }

    protected void createText() {
        $objectMap.put("text", text = new JTextField());
        
        text.setName("text");
        text.setColumns(15);
        SwingUtil.setText(text, "Data Binding");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Text:"));
        createText();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Red:"));
        createRed();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("Green:"));
        createGreen();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("Blue:"));
        createBlue();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("Size:"));
        createDummySize();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,90);
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setMargin(new Insets(0, 0, 0, 0));
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        // inline creation of $VBox1
        $objectMap.put("$VBox1", $VBox1 = new VBox());
        
        $VBox1.setName("$VBox1");
        $VBox1.setSpacing(0);
        createBackgroundCheckbox();
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(t("Red"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(t("Orange"));
        // inline creation of $JRadioButton2
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(t("Yellow"));
        // inline creation of $JRadioButton3
        $objectMap.put("$JRadioButton3", $JRadioButton3 = new JRadioButton());
        
        $JRadioButton3.setName("$JRadioButton3");
        $JRadioButton3.setText(t("Green"));
        // inline creation of $JRadioButton4
        $objectMap.put("$JRadioButton4", $JRadioButton4 = new JRadioButton());
        
        $JRadioButton4.setName("$JRadioButton4");
        $JRadioButton4.setText(t("Cyan"));
        // inline creation of $JRadioButton5
        $objectMap.put("$JRadioButton5", $JRadioButton5 = new JRadioButton());
        
        $JRadioButton5.setName("$JRadioButton5");
        $JRadioButton5.setText(t("Blue"));
        // inline creation of $JRadioButton6
        $objectMap.put("$JRadioButton6", $JRadioButton6 = new JRadioButton());
        
        $JRadioButton6.setName("$JRadioButton6");
        $JRadioButton6.setText(t("Purple"));
        createBackgroundColor();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$VBOX0_BACKGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null && backgroundColor != null) {
                    $VBox0.setBackground((Color)( backgroundCheckbox.isSelected() ? backgroundColor.getSelectedValue() : null));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.removePropertyChangeListener("selectedValue", this);
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (dummySize != null) {
                    $bindingSources.put("dummySize.getModel()", dummySize.getModel());
                    dummySize.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    dummySize.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (dummySize != null) {
                    if ($JLabel5.getFont() != null) {
                        $JLabel5.setFont($JLabel5.getFont().deriveFont((float) dummySize.getValue()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (dummySize != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("dummySize.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    dummySize.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FOREGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JLabel5.setForeground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("red.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("green.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("blue.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (text != null) {
                    $bindingSources.put("text.getDocument()", text.getDocument());
                    text.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    text.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (text != null) {
                    $JLabel5.setText(t(text.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (text != null) {
                    Document $target = (Document) $bindingSources.remove("text.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    }
                    text.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            public void $pr$u3(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add(demoPanel);
        addChildrenToDemoPanel();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(red, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(green, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(blue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dummySize, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JLabel5);
        // inline complete setup of $VBox1
        $VBox1.add(backgroundCheckbox);
        $VBox1.add($JRadioButton0);
        $VBox1.add($JRadioButton1);
        $VBox1.add($JRadioButton2);
        $VBox1.add($JRadioButton3);
        $VBox1.add($JRadioButton4);
        $VBox1.add($JRadioButton5);
        $VBox1.add($JRadioButton6);
        // inline complete setup of $JRadioButton0
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        // inline complete setup of $JRadioButton1
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        // inline complete setup of $JRadioButton2
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
        
        // inline complete setup of $JRadioButton3
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton3); }
        
        // inline complete setup of $JRadioButton4
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton4); }
        
        // inline complete setup of $JRadioButton5
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton5.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton5); }
        
        // inline complete setup of $JRadioButton6
        { ButtonGroup $buttonGroup = backgroundColor; $JRadioButton6.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton6); }
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 11 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Preview"));
        $VBox1.setBorder(BorderFactory.createTitledBorder("Background"));
        { $JRadioButton0.putClientProperty("$value", Color.RED);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton1.putClientProperty("$value", Color.ORANGE);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton2.putClientProperty("$value", Color.YELLOW);  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton3.putClientProperty("$value", Color.GREEN);  Object $buttonGroup = $JRadioButton3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton4.putClientProperty("$value", Color.CYAN);  Object $buttonGroup = $JRadioButton4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton5.putClientProperty("$value", Color.BLUE);  Object $buttonGroup = $JRadioButton5.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton6.putClientProperty("$value", new Color(160, 30, 255));  Object $buttonGroup = $JRadioButton6.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}