package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;

public class BeanFilterableComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TQRieVlqgRQr4cTJKQhUScRe9YhShECFVDHAg9uJ0d2gXtzPjzCxdPHDw4M0/4MGrF8N/IJ5MvHjlP5jwE3xndtlS7BY/epht3nneZ573mXnfLz9RTgo0y0TDooGnGLV2cRhaIqDKaxFr7cn29np9lziqQqQjPK6YQNEvk0XZGiq6SVwqZNWqwGRHTLZmsmMme4m1OKOEniGar6KCVPs+kU1ClEIzqcmOlPZmgpwPeSDis3qq7nXW9/f3jzOk8jGLUMhBfgHKvvsXBJ2qB6oo67kKTVR38R62fUwbIE54tAEFXdaxJR9L+Ry3yBt0gAarKM+xADKF7v2TPYbOUIVcoWK5QlrsBabEn1No+XwJLmxazilbFCMu7AtrkWC64vmKCFwHVtaqs0UWajbODX9eocHylt4E5qk0c2QbSrUMTCcNJ7kTDqM7XiMQWHmMGoUQ1IaEcdKaCWr4SJI1tpNIWgwUnKbQta6cpSZxXoNQjS8laSXZZO0NIomKsnT4ajfkioZUiMNAEBOpsLLDfCa8t2SV7mHfc40xy8ayLRKm0w85sYMKLfT3Kva/Dv6nXEK3JUVBZOCrxKzx7u1RSXzoSOJuGNh5j6u4HqXd5PDG76RJg56yOj3Ved6ZGsqJAMLwBNLbWXfkBqCiXpxK70V9jAG+OzwQn9snx6cNOADiJi/KOjNroBu4YJwI5Wltpaj7AuX59jPM52toOLLFDKLp/so3YySoBxXjmsnSTNZTLJvAlhs8Pvp6/dWPSyi7ggo+w+4K1vhVNKyacDlN5rshf7xgxI20h2Ad0zIVyvt4n8GLQaMPXazwZN2jLtzKoxBcmu7vUiLqcP3k26cPt49OncqAxvKfZHbcyr1EeY/6HiVmWMVzqOdwKnJJApd1hkyvsZPR3wKP58SMWWd/r1+HLb3YYaA/c0a9/vfA7I1dyABtpdtka5+TPjw3/lvJLWD4BY2+mar9BgAA";
    private static final Log log = LogFactory.getLog(BeanFilterableComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox colorizeInvalidComboEditorTextButton;
    protected BeanFilterableComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected JCheckBox filterableButton;
    protected BeanFilterableComboBoxDemoHandler handler;
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanFilterableComboBoxDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo() {
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getColorizeInvalidComboEditorTextButton() {
        return colorizeInvalidComboEditorTextButton;
    }

    public BeanFilterableComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanFilterableComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(colorizeInvalidComboEditorTextButton);
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createColorizeInvalidComboEditorTextButton() {
        $objectMap.put("colorizeInvalidComboEditorTextButton", colorizeInvalidComboEditorTextButton = new JCheckBox());
        
        colorizeInvalidComboEditorTextButton.setName("colorizeInvalidComboEditorTextButton");
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanFilterableComboBox<People>());
        
        comboBox.setName("comboBox");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanFilterableComboBoxDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createShowResetButton();
        createShowDecoratorButton();
        createColorizeInvalidComboEditorTextButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        comboBox.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}