package jaxx.demo.feature.validation.list;
/*
 * #%L
 * JAXX :: Demo
 * $Id: ListBeanValidationDemoHandler.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.16/jaxx-demo/src/main/java/jaxx/demo/feature/validation/list/ListBeanValidationDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.People;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingListValidatorDataLocator;
import jaxx.runtime.validator.swing.SwingListValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.JXTable;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;

import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import java.util.Arrays;
import java.util.UUID;

import static org.nuiton.i18n.I18n.n_;

/**
 * Handler of UI {@link ListBeanValidationDemo}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.3
 */
public class ListBeanValidationDemoHandler {

    private final ListBeanValidationDemo ui;

    public ListBeanValidationDemoHandler(ListBeanValidationDemo ui) {
        this.ui = ui;
    }

    public void initUI() {

        // customize data table

        JXTable dataTable = ui.getDataTable();

        dataTable.getRowSorter().setSortKeys(
                Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer(
                dataTable,
                n_("jaxx.demo.label.id"),
                n_("jaxx.demo.label.id.tip"),
                n_("jaxx.demo.label.firstName"),
                n_("jaxx.demo.label.firstName.tip"),
                n_("jaxx.demo.label.lastName"),
                n_("jaxx.demo.label.lastName.tip"),
                n_("jaxx.demo.label.age"),
                n_("jaxx.demo.label.age.tip"));

        SwingUtil.fixTableColumnWidth(dataTable, 3, 35);

        // register validator
        BeanListValidator<People> validator = ui.getValidator();

        // customize error table

        JTable errorTable = ui.getErrorTable();

        PeopleValidatorDataLocator dataLocator = new PeopleValidatorDataLocator();

        SwingValidatorUtil.installUI(errorTable,
                                     new SwingListValidatorMessageTableRenderer() {

                                         private static final long serialVersionUID = 1L;

                                         Decorator<People> decorator
                                                 = new DemoDecoratorProvider().getDecoratorByType(People.class);

                                         @Override
                                         protected String decorateBean(Object bean) {
                                             return decorator.toString(bean);
                                         }
                                     });

        SwingValidatorUtil.registerListValidator(
                validator,
                ui.getErrorTableModel(),
                dataTable,
                errorTable,
                dataLocator);

        SwingValidatorUtil.addHightLighterOnEditor(
                validator, dataTable, dataLocator,
                NuitonValidatorScope.ERROR,
                NuitonValidatorScope.WARNING);

        // add some datas in model

        People a = new People("0", "Jack", "Black", 12, "/jaxx/demo/images/jack.jpg");
        People a2 = new People("1", "Héctor", "Jiménez", 28, "/jaxx/demo/images/hector.jpg");
        People a3 = new People("2", "Ana", "de la Reguera", 34, "/jaxx/demo/images/ana.jpg");

        addPeople(a);
        addPeople(a2);
        addPeople(a3);
    }

    public void addPeople() {
        People bean = new People();
        bean.setId(UUID.randomUUID().toString());
        addPeople(bean);
    }


    public void addPeople(People bean) {
        PeopleTableModel model = ui.getModel();
        model.addBean(bean);
    }

    public void removePeople() {
        int selectedRow = ui.getDataTable().getSelectedRow();
        PeopleTableModel model = ui.getModel();
        model.removeBean(selectedRow);
    }

    public void updateOkEnabled() {
        BeanListValidator<People> validator = ui.getValidator();
        boolean valid = !validator.hasErrors();
        ui.getOk().setEnabled(valid);
    }

    private static class PeopleValidatorDataLocator implements SwingListValidatorDataLocator<People> {

        @Override
        public boolean acceptType(Class<?> beanType) {
            return People.class.isAssignableFrom(beanType);
        }

        @Override
        public Pair<Integer, Integer> locateDataCell(TableModel tableModel,
                                                     People bean,
                                                     String fieldName) {
            PeopleTableModel model = (PeopleTableModel) tableModel;

            Pair<Integer, Integer> cell =
                    model.getCell(bean, fieldName);
            return cell;
        }

        @Override
        public int locateBeanRowIndex(TableModel tableModel, People bean) {
            PeopleTableModel model = (PeopleTableModel) tableModel;
            return model.getBeanIndex(bean);
        }

        @Override
        public People locateBean(TableModel tableModel, int rowIndex) {
            PeopleTableModel model =
                    (PeopleTableModel) tableModel;
            return model.getBean(rowIndex);
        }
    }

}


