package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JMenuItemDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdm9iO43yRkCghQQSwQELinAIaEkFCIgtbNl9pItyw9i2+Tc57y+4eOVIgfgI/AXoaJDoqREFNQYP4CwhR0CJm1/ZdnBzBwi7Op5n33r6Znbk331FKCnRuBweBJXymaItY5fXt7bv1HdJQm0Q2BOXKE6j9SyRRsoZydhiXCl2oVTS90KEXNrwW9xhhB9grFTQi1TOXSIcQpdCZXkZDysJWmF4JuC+6qqGpONVXP38kX9ovXicRCji4G4ZSlv7FiioZqqAktRWagpOe4oKLWRNsCMqa4HdMxzZcLOUd3CJP0HOUqaA0xwLEFDrff8lGw/ADrlAuv0la3j3MiLus0CVj1oaI1ehKWHIPHFjlKmF+SZGWxnNuFNIKjefLcMau8rjWAIk57TPokg7kNCEb8ibz5RJTRDDsFgUUBMzTPcyerCaNhtxMC6zcwkKhUz2UajscmcvkTQy0Tx4BashUiMzlw/oAPXMErRMaOhMyRh5rY6ZxcGM9BBPUsIlIX/e0SqTETXIYXsH1NnyBw7ws9MwLTKIVTWI0KokaSgkfwtDw2tHhfQCp9tjOHRpbLWiyv2env7z/9q7YndUcnD0TCz2wajBDXHicCEX10RPtQfUVdQtVzFdqKCuJC3tq9nAxxthWJw3m4DxzK5amW7exdEAilfn64ePso88nULKIRlwP20Ws8SWUVY6ALniuHfCba8bR6N4wPCe1N7iPOm7sNoXnM9ig8VUbK7xUp8yGFt8IoBGLMY0I3dSzn35Nb71d6zYjAebm/wqPGpJ6iNKUuZQRs7qdrYxd1RyXxLe9aPvi9jGh/8d4Z4IvmufluGrTDqFNBxZ/arV9/hJW8KWo+4pAtZpmmTL023Lfqqk9+Pw4On3tf0V0+OoxCpN92MjCRdN9XHfJgEIpRdWAIjp8fUAbQ4oE6hiN2b5c3D9GYb4PF9OOJ+i+xxR2113aZPARNaauxEueHdiUVvgDMBLHmNAHAAA=";
    private static final Log log = LogFactory.getLog(JMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel demoMessage;
    protected JPanel framePanel;
    protected JMenuBar menuBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenuItemDemo $DemoPanel0 = this;
    private JDesktopPane $JDesktopPane0;
    private JInternalFrame $JInternalFrame0;
    private JMenu $JMenu0;
    private JMenuItem $JMenuItem0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup(){}

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItemDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JMenuItemDemo() {
        $initialize();
    }

    public JMenuItemDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JMenuItemDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, "Menu item clicked");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getDemoMessage() {
        return demoMessage;
    }

    public JPanel getFramePanel() {
        return framePanel;
    }

    public JMenuBar getMenuBar() {
        return menuBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JDesktopPane get$JDesktopPane0() {
        return $JDesktopPane0;
    }

    protected JInternalFrame get$JInternalFrame0() {
        return $JInternalFrame0;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFramePanel() {
        if (!allComponentsCreated) {
            return;
        }
        framePanel.add(demoMessage);
    }

    protected void addChildrenToMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        menuBar.add($JMenu0);
    }

    protected void create$JInternalFrame0() {
        $objectMap.put("$JInternalFrame0", $JInternalFrame0 = new JInternalFrame());
        
        $JInternalFrame0.setName("$JInternalFrame0");
        $JInternalFrame0.setVisible(true);
        $JInternalFrame0.setClosable(true);
        $JInternalFrame0.setDefaultCloseOperation(2);
        SwingUtil.setComponentHeight($JInternalFrame0,250);
        $JInternalFrame0.setResizable(true);
        $JInternalFrame0.setTitle(t("JMenu demo"));
        SwingUtil.setComponentWidth($JInternalFrame0,300);
    }

    protected void createDemoMessage() {
        $objectMap.put("demoMessage", demoMessage = new JLabel());
        
        demoMessage.setName("demoMessage");
        demoMessage.setText(t("JMenu demo"));
    }

    protected void createFramePanel() {
        $objectMap.put("framePanel", framePanel = new JPanel());
        
        framePanel.setName("framePanel");
    }

    protected void createMenuBar() {
        $objectMap.put("menuBar", menuBar = new JMenuBar());
        
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JDesktopPane0);
        // inline complete setup of $JDesktopPane0
        $JDesktopPane0.add($JInternalFrame0);
        // inline complete setup of $JInternalFrame0
        $JInternalFrame0.getContentPane().add(framePanel);
        $JInternalFrame0.setJMenuBar(menuBar);
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        addChildrenToFramePanel();
        
        // apply 2 property setters
        $JDesktopPane0.setBackground(null);
        demoMessage.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JDesktopPane0
        $objectMap.put("$JDesktopPane0", $JDesktopPane0 = new JDesktopPane());
        
        $JDesktopPane0.setName("$JDesktopPane0");
        SwingUtil.setComponentHeight($JDesktopPane0,400);
        SwingUtil.setComponentWidth($JDesktopPane0,350);
        create$JInternalFrame0();
        createMenuBar();
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("Demo"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(t("Message Box"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        createFramePanel();
        createDemoMessage();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $JInternalFrame0.pack();
        $completeSetup();
    }

}
