package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanFilterableComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdm9iJ7ZBPEgURIEAKCnSOkGgIgpAEi0TmQ0mKCDes7zbxhvPtsruXXCgQP4GfAD0NEh0VoqCmoEH8BYQoaBGz6/M5l9gEiSv2TjPz3r55t7NvvkNOSbiwQ6LIkWGgWZM6q7c3Nx/Ud6irl6lyJROaS2g9mSxka1DykrjScKlWNfByDC8v8abgAQ0OoOerUFR636eqQanWcDaNcJUqryfp+UiEss2aiOrG+urnj+xL78XrLEAkUF0RW5k5DtXppK8KWeZpGMOddknZJ8E2ypAs2Ea9J01sySdK3SdN+hSeQ38V8oJIJNNw8d9bthwWHwkNpdll2uQPSUD9OQ3XrVgPI47bpnBsjHoMSZxFSoIK8zWVpI5UvFnnizwyFEJY0ryG/tkNk0S6qVTvag87cWzOVBYSwJjLgy22HUqiGQ+sFgyafqMYtGqDpnwwQY1sJToWQ615oGEihVlqUPcJqjP1wwlsWDX43hpVVLdQJnwqXTJuSpapy1EQlz3LZl3uc8me0ZVgl/jMs27csT5t0Kg3/YAb26bhWheDYqfr6HQPu9M+lCRVoa8Th0bT6SFFfZwc6q3ZssPGVkm9BTsn8LCeSenBMXA6Y9A5p5ka5GSIYfzDtaOTs4ap1sxMHZoZQ2izvyfHv7z/9q7SHpQ+3Huia+mBOccDLCQXVGpmth5uTUmomV++R8R8DQqtVu0lMN1F2HqcRnG436iBOwbu3CWqgRS5/q8fPk4+/nwCshUo+px4FWLqV6CgG+hyg/teJG4tWEWDewO4jhhtGvI+2ef4v2Hohkc0mamzwEN7b0ZownQXExIl9cKnX+PrbxfaRmRQ2Ome5R0zco8gzwKfBdTeGfF10PWOKAlFQ493xr7bRZAx76KIh/iyXa8c7dSEHbOUo9C85qxk83XV5kaOZcDjb072xr6gf+GZ/m8l55HhD8MsVq1NBgAA";
    private static final Log log = LogFactory.getLog(BeanFilterableComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox colorizeInvalidComboEditorTextButton;
    protected BeanFilterableComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected JCheckBox filterableButton;
    protected final BeanFilterableComboBoxDemoHandler handler = createHandler();
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanFilterableComboBoxDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo() {
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getColorizeInvalidComboEditorTextButton() {
        return colorizeInvalidComboEditorTextButton;
    }

    public BeanFilterableComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanFilterableComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(colorizeInvalidComboEditorTextButton);
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createColorizeInvalidComboEditorTextButton() {
        $objectMap.put("colorizeInvalidComboEditorTextButton", colorizeInvalidComboEditorTextButton = new JCheckBox());
        
        colorizeInvalidComboEditorTextButton.setName("colorizeInvalidComboEditorTextButton");
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanFilterableComboBox<People>());
        
        comboBox.setName("comboBox");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected BeanFilterableComboBoxDemoHandler createHandler() {
        return new BeanFilterableComboBoxDemoHandler();
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
        
        // apply 4 property setters
        comboBox.setBeanType(People.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createShowResetButton();
        createShowDecoratorButton();
        createColorizeInvalidComboEditorTextButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}
