package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.Movie;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.ComboToListSelector;
import jaxx.runtime.swing.ListSelector;
import jaxx.runtime.swing.ListToListSelector;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.model.GenericListEvent;
import jaxx.runtime.swing.model.GenericListListener;
import jaxx.runtime.swing.model.GenericListModel;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ListSelectorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_TOOL_TIP = "addToolTip";
    public static final String PROPERTY_REMOVE_TOOL_TIP = "removeToolTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_TOOL_TIP_FIELD_TEXT = "addToolTipField.text";
    public static final String BINDING_COMBO_TO_LIST_SELECTOR_ADD_TOOL_TIP = "comboToListSelector.addToolTip";
    public static final String BINDING_COMBO_TO_LIST_SELECTOR_REMOVE_TOOL_TIP = "comboToListSelector.removeToolTip";
    public static final String BINDING_LIST_TO_LIST_SELECTOR_ADD_TOOL_TIP = "listToListSelector.addToolTip";
    public static final String BINDING_LIST_TO_LIST_SELECTOR_REMOVE_TOOL_TIP = "listToListSelector.removeToolTip";
    public static final String BINDING_REMOVE_TOOL_TIP_FIELD_TEXT = "removeToolTipField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVPW8TQRBdm9iJnU8SSIJiICEmQkicg0SB5CgEHFkQGYhiFwFLiD3fKrlofXvs7jmXBvET+AnQ0yDRUSEKagoaxF9AiIIWMbv+OF98JJbs4mzPzHvzZnZn7t1PlBAcLR1g3ze450i7Toytu7u7j80DUpObRNS47UrGUfMTi6N4FY1aHbuQaLlaUvBcC54rsLrLHOJ0ofMllBbyiBKxT4iU6GIYURMiV+64877r8TZrR1QU65vfv+KvrVdv4wj5LqibgFIWT0MFlQyVUNy2JJqGTA2co9jZAxncdvZA77iyFSgW4hGukxfoJRouoaSLOZBJdKX/kjWHxvuuRKPZTVJn29ghdFWiVS3WAotRa1MY2kYsG0iMki1kmVA4CsYV0HU1VVKiKQquAqF0hzgW4YRLlFGSfUMcQgUa2e0OkGMWlnibs4ZtKdRyoAGy29ImwlCpNruiAnAaW1aFMVqBItGUSmiovhnNvgVx4xwoGqQVqoznAudwtoJNSqAB86HTairXPhWZ6gBGslslbOqWTXcX2bSqoLlO7GSgsGgTCuc7G4JUiC+1Iwxrp7ip/mfCvulQMR3w5XDUeHarXOOMUnW6oHQulDZwhVEzcPAmq7Duk5ZoJaIvhd5AxZGNFqDrWDlWh7ozx1NdjUhV6olTDNddmK+FUDhMrhFMbjBasSpKcA/McMTV3mHfAVdzzOePjbki1N6/szPfPv74UGzP9hjkPh8Z2rWaYOZczly41rZKPdkcbE/aNPcQu/kqSolWPeDNRAhrlwviIN9Zfb8V3LiPxT5QJIa/f/o8+/zrGRQvojRl2CpiFf8ApeQ+hy4wavnunQ2taOxwBJ5TSptESYqPmAerY2JNzd+iaTsWtHrdhyZkIprQUWKmvvyZKb/faDciBsIu/Dc8aEbiKUraDrUdotdca4NFrrVRVxDPYsGmitpdMfWddltTfEs/b0dVOiRhwuCyrTWzL2IJu8H0JIFaFWhNF6F+rWvOhVM5lfmeeuSjGS71z1CIZlgaWMNyH53pWp4nMF3rg6l3vQ5ANsJb74gBeZINTD0iBmJR5soJDDf6YngyMMOzUxj+AUFUatE5CQAA";
    private static final Log log = LogFactory.getLog(ListSelectorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String addToolTip;
    protected JTextField addToolTipField;
    protected ComboToListSelector<Movie> comboToListSelector;
    protected DemoDataProvider dataProvider;
    protected ListCellRenderer listCellRenderer;
    protected ListToListSelector<People> listToListSelector;
    protected String removeToolTip;
    protected JTextField removeToolTipField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListSelectorDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<People> getActors(Collection<Movie> movies) {
        List<People> actors = Lists.newArrayList();
        for (Movie m : movies) {
            List<People> actorsToAdd = m.getActors();
            actors.removeAll(actorsToAdd);
            actors.addAll(actorsToAdd);
        }
        return actors;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListSelectorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListSelectorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ListSelectorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ListSelectorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListSelectorDemo() {
        $initialize();
    }

    public ListSelectorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ListSelectorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public ListSelectorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__addToolTipField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAddToolTip(addToolTipField.getText());
    }

    public void doKeyReleased__on__removeToolTipField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setRemoveToolTip(removeToolTipField.getText());
    }

    public void doValuesAdded__on__comboToListSelector(GenericListEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        listToListSelector.setValues(getActors(comboToListSelector.getSelectedValues()));
    }

    public void doValuesRemoved__on__comboToListSelector(GenericListEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        listToListSelector.setValues(getActors(comboToListSelector.getSelectedValues()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getAddToolTip() {
        return addToolTip;
    }

    public JTextField getAddToolTipField() {
        return addToolTipField;
    }

    public ComboToListSelector<Movie> getComboToListSelector() {
        return comboToListSelector;
    }

    public DemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public ListCellRenderer getListCellRenderer() {
        return listCellRenderer;
    }

    public ListToListSelector<People> getListToListSelector() {
        return listToListSelector;
    }

    public String getRemoveToolTip() {
        return removeToolTip;
    }

    public JTextField getRemoveToolTipField() {
        return removeToolTipField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddToolTip(String addToolTip) {
        String oldValue = this.addToolTip;
        this.addToolTip = addToolTip;
        firePropertyChange(PROPERTY_ADD_TOOL_TIP, oldValue, addToolTip);
    }

    public void setRemoveToolTip(String removeToolTip) {
        String oldValue = this.removeToolTip;
        this.removeToolTip = removeToolTip;
        firePropertyChange(PROPERTY_REMOVE_TOOL_TIP, oldValue, removeToolTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddToolTip() {
        $objectMap.put("addToolTip", addToolTip = "Add");
    }

    protected void createAddToolTipField() {
        $objectMap.put("addToolTipField", addToolTipField = new JTextField());
        
        addToolTipField.setName("addToolTipField");
        addToolTipField.setColumns(15);
        addToolTipField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__addToolTipField"));
    }

    protected void createComboToListSelector() {
        $objectMap.put("comboToListSelector", comboToListSelector = new ComboToListSelector<Movie>());
        
        comboToListSelector.setName("comboToListSelector");
        comboToListSelector.addGenericListListener(JAXXUtil.getEventListener(GenericListListener.class, "valuesAdded", this, "doValuesAdded__on__comboToListSelector"));
        comboToListSelector.addGenericListListener(JAXXUtil.getEventListener(GenericListListener.class, "valuesRemoved", this, "doValuesRemoved__on__comboToListSelector"));
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new DemoDataProvider());
    }

    protected void createListCellRenderer() {
        $objectMap.put("listCellRenderer", listCellRenderer = new DecoratorProviderListCellRenderer(new DemoDecoratorProvider()));
    }

    protected void createListToListSelector() {
        $objectMap.put("listToListSelector", listToListSelector = new ListToListSelector<People>());
        
        listToListSelector.setName("listToListSelector");
    }

    protected void createRemoveToolTip() {
        $objectMap.put("removeToolTip", removeToolTip = "Remove");
    }

    protected void createRemoveToolTipField() {
        $objectMap.put("removeToolTipField", removeToolTipField = new JTextField());
        
        removeToolTipField.setName("removeToolTipField");
        removeToolTipField.setColumns(15);
        removeToolTipField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__removeToolTipField"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addToolTipField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(removeToolTipField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(comboToListSelector);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(listToListSelector);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        comboToListSelector.setRenderer(listCellRenderer);
        comboToListSelector.setValues(dataProvider.getMovies());
        listToListSelector.setRenderer(listCellRenderer);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createListCellRenderer();
        createDataProvider();
        createAddToolTip();
        createRemoveToolTip();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("jaxxdemo.listSelector.addToolTipLbl"));
        createAddToolTipField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("jaxxdemo.listSelector.removeToolTipLbl"));
        createRemoveToolTipField();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createComboToListSelector();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createListToListSelector();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_FIELD_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(addToolTipField, getAddToolTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_FIELD_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(removeToolTipField, getRemoveToolTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_TO_LIST_SELECTOR_ADD_TOOL_TIP, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                comboToListSelector.setAddToolTip(getAddToolTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_TO_LIST_SELECTOR_REMOVE_TOOL_TIP, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                comboToListSelector.setRemoveToolTip(getRemoveToolTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_TO_LIST_SELECTOR_ADD_TOOL_TIP, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                listToListSelector.setAddToolTip(getAddToolTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_TO_LIST_SELECTOR_REMOVE_TOOL_TIP, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                listToListSelector.setRemoveToolTip(getRemoveToolTip());
            }
        });
    }

}