package jaxx.demo.component.jaxx.widgets.select;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;

public class FilterableDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUQU8TQRR+LbbQFgVpQIiYgHIz2arEE0YRKlFS1AAHYi9Ou0N3cDszzsza5WL8Cf4EvXsx8ebJePDswYvxLxjjwavxzbTdUixCYpPuNu9975vvfdP33nyHjFYwv0fi2FMRN6xJvfXbOzsPanu0bspU1xWTRihof1JpSFeh4CdxbeBStWLLS53y0qpoSsEpP1C9VIG8Nvsh1QGlxsCF/oq61qWtJL0Uy0h1WRNRg1hf/fyRfum/eJ0GiCWqK2Arc8dV9To5VYE08w1M4EnPSCkkvIEyFOMN1HvaxlZDovV90qRP4TkMVyAriUIyAxdP3rLjcPWxNFBYKNOmeEg4Da8YWHZifYx49S6F52It5jeo0Z6mId6Dt8ZCQxWphbQsInxWmDaWSEpHnTWQaQqfhgbu/C/lhuXp8Q4vbFsMip3uc1a30CfP5SwylxRM1AXfZY1IEcMEd51i0LoZd4rWXdDCx5Kq8d1EzkpkjOAGJvtqVgNaf7IiYoufSMpmAtYIQvyadjvbNDbtegs41w8e04FobVJNj4YULaRM6wLVC3UkbJTyntIB+byfWGpgUaiGxyOG0BNfRL85WUV1FJrDlthmrZUdsILzfTeEU+X1pqr3t09VIaMiDOOVVv8exE1MtUdw+tAIWkKX/T1V/PL+27u17twN4dmTA6EH1gbOg1RCUmWYPXqsPXSRYWFpg8ilKuTafridMjtA2FYnjeLwvLO23LPl3l2iA6TIDH/98HHq8echSK9BPhTEXyMWfw9yJkAHAxH6sby17BSNtkbwOW61ob8h2Rd4l3Dmhk8Mmasx7qPDN2M0YXaACYmSWu7Tr+LW2+WuESkUNnMkvGdG5hFkGQ8Zp24FdbbLwJVTkJpGvuhtkUF7JWXfedmZ2svuWfq7Uxu+ah/X4si+Fp1k++u6yxWPZTAwUqOEb+9L+g+eeeT5A3DCnC9aBgAA";
    private static final Log log = LogFactory.getLog(FilterableDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected FilterableDoubleList<People> doubleList;
    protected JCheckBox enableButton;
    protected JCheckBox filterableButton;
    protected final FilterableDoubleListDemoHandler handler = createHandler();
    protected JCheckBox highlightFilterTextButton;
    protected FilterableDoubleListDemoModel model;
    protected JTextPane result;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FilterableDoubleListDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterableDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterableDoubleListDemo() {
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public FilterableDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public FilterableDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public FilterableDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public FilterableDoubleListDemoModel getModel() {
        return model;
    }

    public JTextPane getResult() {
        return result;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(enableButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new FilterableDoubleList<People>());
        
        doubleList.setName("doubleList");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected FilterableDoubleListDemoHandler createHandler() {
        return new FilterableDoubleListDemoHandler();
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FilterableDoubleListDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JTextPane());
        
        result.setName("result");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
        
        // apply 3 property setters
        doubleList.setBeanType(People.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createEnableButton();
        createDoubleList();
        createResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}