/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.nav;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.lang.reflect.Constructor;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.demo.entities.*;
import jaxx.demo.feature.nav.*;
import jaxx.demo.feature.nav.content.*;
import jaxx.demo.feature.nav.tree.*;
import jaxx.demo.feature.nav.treetable.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class NavDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz08TQRQeqi0WVBAi/kJFxfgjulUPJgZ/oCBBUpRQosR6cNod6OB0Z5yZLYsH45/gn6B3LybePBkPnj14Mf4Lxnjwanyzu93tylKbVA6FzHvf9773Zt5X3nxHWSXRsTXseZZ0HU3rxJq7ubx8r7JGqnqaqKqkQnOJgp+eDMqUUb8dnSuNTpSLBl4I4YUpXhfcIU4LeqKI+pTeYETVCNEaHU4iqkoVSlF4whOubLJGotJYX/38kXlpv3idQcgToG4AWhn7FyruZHsRZait0RBUauACw84qyJDUWQW9u8zZFMNK3cV18hQ9R71FlBNYAplGxztv2efw8Z7QqH98mtT5AnYIuwBz8MXacGKtEKxdSSwHN6y7uGGyhPBxOY12Vbmjgb6IN7gL5Y8kmlTrINmawtIO4pdi4E4ba7wgeYPaRGp0pm296ZbcmKJPS0JmCROG4Fw6gUlpsixF6THHgElYwhUWEV3emkibvFa2FmBM2VvDjs0M1XjbpmaDtBiYV4JRbW5AoxFzyV44wLlSM2Ay8/Hwx+dAQYXYJgSXti8BikMm/VArqlSVnLFUVBwy6Uci1G5QTlexptwxnWu0J1kMzkzmsfQyF83hiSTjcJLRn6VGR7lctdZgjZ9oLgJ2z5pbjjIM+FQ86/D5waok5PjPONl2fhzwd5wVDi0fTHmlYVRsBvjiL0JAokMJILiDFbtDvL49ZZSVLhxrtL+82VAWIRRYyf6/rMQQ+tHfI8Nf3n97N9P0jz1Qe29qaov9wV4Lyc0jpqb0QGAerqasMI/FRBkeGGHgnb43jqYIK4VhEAf1/Au2DNyaxaoGFNnerx8+jjz+vA1lZlAf49iewSb/DsrrmoQpcGZ74sakr2jn+g74HDTaNMqx0B92XzV7P1ahjg1Dv+7BEEZThhApqeQ//RouvZ1sDqIHhB3YMj0eRvYhylGHUYf4Vhq6ZKp19gtFXJvHbpjmjz3md58IX8cV//NaWqdD4LZL3K3WbnsCFjx41ENXAy1jWIOLV1xNoHNDcdNvyfw15VcY7aBCrsIl+KCJT6azHO+A5UCNS/oMtgezYE1vYbnAGa1udEm8r2EeYPV/0+ZXQOt5RZ/51zabTnSyA6JsnduBN2yhphOSfsm5vk8VDR2pCz2DsDbrahH4gi8E1RWfOZ5v09zpjhgWu2Z40DXDozZzONsRw0rXDE+6YgC3i/67mP/Ho+tMz402DOeB4Q9RuBbfNQsAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.nav.NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected jaxx.demo.feature.nav.NavDemoDataProvider dataProvider;
    protected jaxx.demo.feature.nav.NavDemoHandler handler;
    protected javax.swing.JTree navigationTree;
    protected org.jdesktop.swingx.JXTreeTable navigationTreeTable;
    protected javax.swing.JSplitPane splitPane;
    protected jaxx.demo.feature.nav.tree.NavDemoTreeHelper treeHelper;
    protected jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0 = this;
    private javax.swing.JTabbedPane $JTabbedPane0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(),
                "NavDemoHandler.java",
                "NavDemoDataProvider.java",
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         };
    }
    
    private void $afterCompleteSetup() {
        getHandler().$afterCompleteSetup();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo() {
        super();
        $initialize();
    }

    public NavDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public jaxx.demo.feature.nav.NavDemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public jaxx.demo.feature.nav.NavDemoHandler getHandler() {
        return handler;
    }

    public javax.swing.JTree getNavigationTree() {
        return navigationTree;
    }

    public org.jdesktop.swingx.JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    public jaxx.demo.feature.nav.tree.NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new jaxx.demo.feature.nav.NavDemoDataProvider());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.demo.feature.nav.NavDemoHandler(this));
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new javax.swing.JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new org.jdesktop.swingx.JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new jaxx.demo.feature.nav.tree.NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("jaxxdemo.tree.tabtitle"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("jaxxdemo.treeTable.tabtitle"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createHandler();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new javax.swing.JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo0.setTitle(_("jaxxdemo.tree.tabtitle"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo1.setTitle(_("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}