/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JRadioButtonDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu24TQRS9NrFjx3mQGEKAIIXgAgFaAw1FopCXTIjMQ4kURbhh7B3FG613hpnZZKFAfAKfAD0NEh0VoqCmoEH8AkIUtIg7s7bXJhvHkl3sWjP3nHvO9bl+9xNSUsDlfRIElvA95TSotbmyu/uouk9rap3KmnC4YgLCTyIJyQrk7Pa5VHClUtbwYhNeXGMNzjzqdaAXyjAi1XOXyjqlSsGlbkRNyuJ2+3oh4L5osbZFxbG++f0r+dp+9TYJEHBUl0ErcyehIidDZUg6toIp7HRAii7x9lCGcLw91Dumz9ZcIuVD0qDP4CUMlyHNiUAyBfP9WzYcBh9wBbnCOm2wx8Sj7k0F14xYG0+sWovCkoeowNrcIrbDVn2lmKchnBuStIJ0YWOVBYg+12U1hOkrXZftKN85vnynWT7aLh8vdHZG2IweRBCjSgMmjsHd0qdnelXcjqnIFDbLpGomM9XV1Zx26xwVEReGcD7GnM5xWHBPMJ/jBAVc7KrD4FlR8KJkJCqQEj4eo/3K0axu4VWY0pn/UqoJze3f6fy3jz8+lFrRHMPeZ2NLOzYLI8MF41QoR7eeCHPpK8ctPiB8oQJZSV1cS7N2szHCtpvXKA77TWq4peHWBpF1pEgNf//0efrp11OQLMGIy4hdIrr+PmRVXeAUmGsH/O6yUTR6mMHnaa1NQb7OhPOCeYq4K66z5zXMGkwtOp7reHSOKNybqq/oUoBTmY2ZSltaNfvlT377/XJrMglUev7Y8mg6qSeQDruZtW1uZOya5rikvs2izYvbxYR+j/HmXhXM82qc9ckD/YPUOozr0uuBr183jAP9zeqbMFeNQtmDKt8HVSYMBLUH5BlSNOhlqx+O1AFxfToQiT6+04Nhui+GlYEZSgMz9HIxM7CL/hh6uTiZAUPh1HDhYXzRJorMVR3Pxn/VpXi+C8j3D1JiULxNCAAA";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JRadioButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JRadioButtonDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.HBox $HBox0;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JRadioButton $JRadioButton0;
    private javax.swing.JRadioButton $JRadioButton1;
    private javax.swing.JRadioButton $JRadioButton2;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButtonDemo() {
        super();
        $initialize();
    }

    public JRadioButtonDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HBox get$HBox0() {
        return $HBox0;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected javax.swing.JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected javax.swing.JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void create$JRadioButton0() {
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new javax.swing.JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(_("Animal"));
        { $JRadioButton0.putClientProperty("$value", "Lynx.jpg");  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void create$JRadioButton1() {
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new javax.swing.JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(_("Vegetable"));
        { $JRadioButton1.putClientProperty("$value", "Tomato.jpg");  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void create$JRadioButton2() {
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new javax.swing.JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(_("Mineral"));
        { $JRadioButton2.putClientProperty("$value", "Amethyst.jpg");  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new jaxx.runtime.swing.JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add($VBox0);
        $HBox0.add($JLabel0);
        // inline complete setup of $VBox0
        $VBox0.add($JRadioButton0);
        $VBox0.add($JRadioButton1);
        $VBox0.add($JRadioButton2);
        // inline complete setup of $JRadioButton0
        { javax.swing.ButtonGroup $buttonGroup = radioButtons; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        // inline complete setup of $JRadioButton1
        { javax.swing.ButtonGroup $buttonGroup = radioButtons; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        // inline complete setup of $JRadioButton2
        { javax.swing.ButtonGroup $buttonGroup = radioButtons; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
        
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new jaxx.runtime.swing.HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        create$JRadioButton0();
        create$JRadioButton1();
        create$JRadioButton2();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        createRadioButtons();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (radioButtons != null) {
                    radioButtons.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (radioButtons != null) {
                    $JLabel0.setIcon(new ImageIcon(getClass().getResource("/jaxx/demo/images/" + radioButtons.getSelectedValue())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (radioButtons != null) {
                    radioButtons.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
    }

}