/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.jaxx.editor.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ComboEditorDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_AREA0_TEXT = "$JTextArea0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS2/TQBCehCZpmrb0oUatWkSBqAcETkFwSgWt2kYQmYdoDxW5sI5XrauNvazX1L0gfgI/Ae5ckLhxQhw4c+CC+AsIceCKmN04dg3uA9WHtTMz3zffzM7kzXco+AIu7JIwNETgSqdLjdbK1tYDa5d25Br1O8Lh0hPQe3J5yLehYsd2X8Kltqng9QheX/W63HOpewDdMGHIl/uM+juUSgnn0oiO79c3Yncj5IHos8aislhf/fyRf2m/eJ0HCDmqK2Mp88ehkkoGTMg7toQJzPSM1Blxt1GGcNxt1DuibKuM+P590qVP4TmUTChyIpBMwsWTl6w5ND7kEiq1Ndr1HhKXskUJdS3WRovR6VMY2kZtB0mUfstb198Kx7lmKkoo1TaJxShyTKcK9vdQvqF9KrIcAwZrLZNYOuuEKi2MQntWFTQcxw4zr0MY7eWVsJCRIdJnHghMc/TzXVO/x9O+UdXqgGzHGWqHZ1h3g+5R/Ncz+Ec6HlKJ/QQ3kw6o1FqbNJQrghLsx1SqH31HhBAwmxKHs2oks5oMU64NBRGgGW+k/e94P0JXb7Cn/xpsRai9v6uTX95/e9fsT3MJc09lhh5YRpwyLjxOhXRU6rO9UQ6kw+r3CG+0cScow03WmzqXIWwjcqM4zDeu4IaCG3eIv4MUhdLXDx+rTz6fgXwThphH7CZR8XehLHcEdsFjdshvL2tFw3uDeI4pbXhDTN1PU93v6JJNJJm3HNfGHt8KsQ1zGW2ItVjlT78mN94u91uRQ2kzh4Yn7Sg8hqLjMselerWjrc1c5Qr3aWB7yXZm7WtOvcd4tHYL+rycVeuAxKnBzVrqZZ8nEv9HrEBSrFWBDF2E+lo8IacyX1HH1WyG6okYbqjj5mkYjtIwe2oN/8FwiIbzyPAHAiWkisYGAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.jaxx.editor.ComboEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.EnumEditor countryEditor;
    protected jaxx.runtime.swing.editor.EnumEditor languageEditor;
    protected jaxx.runtime.swing.editor.LocaleEditor localeEditor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComboEditorDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JTextArea $JTextArea0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComboEditorDemo() {
        super();
        $initialize();
    }

    public ComboEditorDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.editor.EnumEditor getCountryEditor() {
        return countryEditor;
    }

    public jaxx.runtime.swing.editor.EnumEditor getLanguageEditor() {
        return languageEditor;
    }

    public jaxx.runtime.swing.editor.LocaleEditor getLocaleEditor() {
        return localeEditor;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JTextArea get$JTextArea0() {
        return $JTextArea0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new jaxx.runtime.swing.editor.EnumEditor(org.nuiton.i18n.CountryEnum.class));
        
        countryEditor.setName("countryEditor");
    }

    protected void createLanguageEditor() {
        $objectMap.put("languageEditor", languageEditor = new jaxx.runtime.swing.editor.EnumEditor(org.nuiton.i18n.LanguageEnum.class));
        
        languageEditor.setName("languageEditor");
    }

    protected void createLocaleEditor() {
        $objectMap.put("localeEditor", localeEditor = new jaxx.runtime.swing.editor.LocaleEditor());
        
        localeEditor.setName("localeEditor");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localeEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(languageEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryEditor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextArea0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $JLabel0.setLabelFor(localeEditor);
        $JLabel1.setLabelFor(languageEditor);
        $JLabel2.setLabelFor(countryEditor);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Locale editor:"));
        createLocaleEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("EnumEditor (language) :"));
        createLanguageEditor();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("EnumEditor (country) :"));
        createCountryEditor();
        // inline creation of $JTextArea0
        $objectMap.put("$JTextArea0", $JTextArea0 = new javax.swing.JTextArea());
        
        $JTextArea0.setName("$JTextArea0");
        $JTextArea0.setColumns(15);
        $JTextArea0.setLineWrap(true);
        $JTextArea0.setWrapStyleWord(true);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_AREA0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (localeEditor != null) {
                    $bindingSources.put("localeEditor", localeEditor);
                    localeEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (languageEditor != null) {
                    $bindingSources.put("languageEditor", languageEditor);
                    languageEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (countryEditor != null) {
                    $bindingSources.put("countryEditor", countryEditor);
                    countryEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (localeEditor != null && countryEditor != null && languageEditor != null) {
                    jaxx.runtime.SwingUtil.setText($JTextArea0, "locale : "+ localeEditor.getSelectedItem() + "\nlanguage : "+ languageEditor.getSelectedItem() + "\ncountry : " + countryEditor.getSelectedItem());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (localeEditor != null) {
                    jaxx.runtime.swing.editor.LocaleEditor $target = ((jaxx.runtime.swing.editor.LocaleEditor) $bindingSources.remove("localeEditor"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (languageEditor != null) {
                    jaxx.runtime.swing.editor.EnumEditor $target = ((jaxx.runtime.swing.editor.EnumEditor) $bindingSources.remove("languageEditor"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (countryEditor != null) {
                    jaxx.runtime.swing.editor.EnumEditor $target = ((jaxx.runtime.swing.editor.EnumEditor) $bindingSources.remove("countryEditor"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ItemEvent event) {
                propertyChange(null);
            }
        });
    }

}