/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.*;
import jaxx.demo.tree.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class DemoUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(jaxx.demo.DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.demo.DemoConfig config;
    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected jaxx.demo.DemoUIHandler handler;
    protected DemoUI mainFrame = this;
    protected javax.swing.JPanel mainPane;
    protected javax.swing.JMenuBar menu;
    protected javax.swing.JMenu menuFile;
    protected javax.swing.JMenuItem menuFileConfiguration;
    protected javax.swing.JMenuItem menuFileExit;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenu menuFileLanguage;
    protected javax.swing.JMenuItem menuFileLanguageFR;
    protected javax.swing.JMenuItem menuFileLanguageUK;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected javax.swing.JMenu menuHelp;
    protected javax.swing.JMenuItem menuHelpAbout;
    protected javax.swing.JMenuItem menuHelpHelp;
    protected javax.swing.JMenuItem menuHelpSite;
    protected javax.swing.JTree navigation;
    protected javax.swing.JScrollPane navigationPane;
    protected jaxx.runtime.swing.StatusMessagePanel p;
    protected javax.swing.JSplitPane splitPane;
    protected jaxx.demo.tree.DemoTreeHelper treeHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }
    
    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(java.awt.event.ActionEvent event) {
        getHandler().close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(java.awt.event.WindowEvent event) {
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.demo.DemoConfig getConfig() {
        return config;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public jaxx.demo.DemoUIHandler getHandler() {
        return handler;
    }

    public javax.swing.JPanel getMainPane() {
        return mainPane;
    }

    public javax.swing.JMenuBar getMenu() {
        return menu;
    }

    public javax.swing.JMenu getMenuFile() {
        return menuFile;
    }

    public javax.swing.JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public javax.swing.JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public javax.swing.JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public javax.swing.JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public javax.swing.JMenu getMenuHelp() {
        return menuHelp;
    }

    public javax.swing.JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public javax.swing.JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public javax.swing.JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public javax.swing.JTree getNavigation() {
        return navigation;
    }

    public javax.swing.JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public jaxx.runtime.swing.StatusMessagePanel getP() {
        return p;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    public jaxx.demo.tree.DemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemoUIHandler.class));
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new javax.swing.JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new javax.swing.JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new javax.swing.JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("jaxxdemo.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new javax.swing.JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("jaxxdemo.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new javax.swing.JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("jaxxdemo.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new javax.swing.JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new javax.swing.JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setMnemonic(70);
        menuFileLanguageFR.setToolTipText(_("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new javax.swing.JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new javax.swing.JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("jaxxdemo.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new javax.swing.JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("jaxxdemo.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new javax.swing.JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("jaxxdemo.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new javax.swing.JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("jaxxdemo.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new javax.swing.JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new javax.swing.JScrollPane());
        
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new jaxx.runtime.swing.StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = getContextValue(DemoTreeHelper.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        setIconImage(jaxx.runtime.SwingUtil.createIcon(getConfig().getOption("application.icon.path")).getImage());
        menuFileConfiguration.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config"));
        menuFileLanguage.setIcon(jaxx.runtime.SwingUtil.createActionIcon("translate"));
        menuFileLanguageFR.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(jaxx.runtime.SwingUtil.createActionIcon("exit"));
        menuHelpHelp.setIcon(jaxx.runtime.SwingUtil.createActionIcon("help"));
        menuHelpSite.setIcon(jaxx.runtime.SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(jaxx.runtime.SwingUtil.createActionIcon("about"));
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        navigation.setModel(getTreeHelper().createModel());
        navigation.setCellRenderer(new DemoCellRenderer(getTreeHelper().getDataProvider()));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("mainFrame", this);
        createContentLayout();
        createConfig();
        createHandler();
        createTreeHelper();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(_("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}