/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class JComboBoxDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TEXT = "$JButton0.text";
    private static final String BINDING_$JBUTTON1_TEXT = "$JButton1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Uz08TURCeVtpSigo0FAiooE08mGwF48FAEIE00tQfEQ/EXnzbfYEl293n7qysF+Of4J+gdy8m3jwZD549eDH+C8Z48Gqc97a7ZetC28O2nZnvm2+m3/TdT8h5LiwdsiDQXN9Gs8O1xp29vQf6IW/jNvfarinQcSF8ZbKQbUHJiOMewpVWU8JrXXhty+kIx+b2MfRqE8Y8fGFx74BzRLiQRLQ9r7Ybp1cD4bsRaywqjfXN71/Z18art1mAQJC6Eo2yOAjVm2SkCVnTQJiiTs9ZzWL2PslwTXuf9J6VsS2Led591uHP4CUUmpAXzCUyhMvDj6w4FD4QCKXqNu84D5nNresIV5VYgyJaO6LQvCNSoDWIU3c2nUDWC6EY8giF6mOmW5yws4lBQ5DKycpiDBitNppMV92m5EhBxK+ismg8rh2XlFFfhEspHaQ3oookuFhtbPqIjk2dyolOYThZHclalt8n+3LtWMJ0gmhAY8U1k0zmqzvIOyRpJmUYmRJ9pYpkqT+6EkVdmE8QkXW1nnV73sq0IOf6FKYfqvW/2x9RKvT5bJ/PJaHK/q2Uv3388aEembtAvadTS4/dJplOuI7gLpqy9fnQ2T6aVu0eE6stKHrcosNWh7uQImy3myZx1G9SwjUJ1+4y74AocoXvnz5Xnn49A9k6jFkOM+pM1u9AEQ9c2oJjGYG4vaEUjR+N0nNCakMYQR7Q5UytmbZl2nyRIZ2a7iNfD2gNCylriLXoxS9/yrvvN6JVZEja3InlvXXknkA+7KYuvXvEqZddEh73Dad3rGnnm5HvE6JrjmvqWUubdZQbJka3uBL48u2GEi4/3VQ85YE8MryMcG7NYMgWddM2yLTr6WyV4dhO0TM3FMOtUxjmh9hMruMY4d/OCYMMJokHOYHhIjH8AwF4zVzYBgAA";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JComboBox comboBox;
    protected jaxx.runtime.swing.JAXXComboBox jaxxComboBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JComboBoxDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JButton $JButton1;
    private jaxx.runtime.swing.Item $Item0;
    private jaxx.runtime.swing.Item $Item1;
    private jaxx.runtime.swing.Item $Item2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    private void $afterCompleteSetup() {
        jaxxComboBox.setSelectedIndex(0);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBoxDemo() {
        super();
        $initialize();
    }

    public JComboBoxDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JComboBox getComboBox() {
        return comboBox;
    }

    public jaxx.runtime.swing.JAXXComboBox getJaxxComboBox() {
        return jaxxComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected jaxx.runtime.swing.Item get$Item0() {
        return $Item0;
    }

    protected jaxx.runtime.swing.Item get$Item1() {
        return $Item1;
    }

    protected jaxx.runtime.swing.Item get$Item2() {
        return $Item2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToJaxxComboBox() {
        if (!allComponentsCreated) {
            return;
        }
        java.util.List<jaxx.runtime.swing.Item> jaxxComboBox$items = new java.util.ArrayList<jaxx.runtime.swing.Item>();
        jaxxComboBox$items.add($Item0);
        jaxxComboBox$items.add($Item1);
        jaxxComboBox$items.add($Item2);
        jaxxComboBox.setItems(jaxxComboBox$items);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new javax.swing.JComboBox());
        
        comboBox.setName("comboBox");
        comboBox.setEditable(true);
    }

    protected void createJaxxComboBox() {
        $objectMap.put("jaxxComboBox", jaxxComboBox = new jaxx.runtime.swing.JAXXComboBox());
        
        jaxxComboBox.setName("jaxxComboBox");
        jaxxComboBox.setEditable(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(jaxxComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToJaxxComboBox();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $Item0.setValue(_("OK"));
        $Item1.setValue(_("Cancel"));
        $Item2.setValue(_("Help"));
        comboBox.setModel(new  DefaultComboBoxModel(new Object[]{n_("OK"),n_("Cancel"),n_("Help")}));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Button label:"));
        createJaxxComboBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Button label:"));
        createComboBox();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        // inline creation of $Item0
        $objectMap.put("$Item0", $Item0 = new jaxx.runtime.swing.Item("$Item0", null, "<data binding has not been processed yet>", true));
        // inline creation of $Item1
        $objectMap.put("$Item1", $Item1 = new jaxx.runtime.swing.Item("$Item1", null, "<data binding has not been processed yet>", false));
        // inline creation of $Item2
        $objectMap.put("$Item2", $Item2 = new jaxx.runtime.swing.Item("$Item2", null, "<data binding has not been processed yet>", false));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (jaxxComboBox != null) {
                    $bindingSources.put("jaxxComboBox", jaxxComboBox);
                    jaxxComboBox.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (jaxxComboBox != null) {
                    $JButton0.setText(_(String.valueOf(jaxxComboBox.getSelectedItem())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (jaxxComboBox != null) {
                    jaxx.runtime.swing.JAXXComboBox $target = ((jaxx.runtime.swing.JAXXComboBox) $bindingSources.remove("jaxxComboBox"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ItemEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    $bindingSources.put("comboBox", comboBox);
                    comboBox.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null) {
                    $JButton1.setText(_(comboBox.getSelectedItem()+""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    javax.swing.JComboBox $target = ((javax.swing.JComboBox) $bindingSources.remove("comboBox"));
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(java.awt.event.ItemEvent event) {
                propertyChange(null);
            }
        });
    }

}