package jaxx.demo.feature.databinding;

import javax.swing.*;
import java.io.File;

/**
 * Created: 2 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1692 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-21 21:11:57 +0100 (lun., 21 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public interface DemoUIModel {

    Boolean isF0();

    Boolean isF1();

    void setF0(Boolean b);

    void setF1(Boolean b);

    JToggleButton getT0();

    JToggleButton getT1();

    File getFile();

    void setFile(File newValue);

    /**
     * All <code>JAXXObject</code> implements are capable of broadcasting <code>PropertyChangeEvent</code>, and
     * furthermore (for technical reasons) must allow code in outside packages, specifically the JAXX runtime,
     * to trigger these events.
     *
     * @param name     the name of the property which changed
     * @param oldValue the old value of the property
     * @param newValue the new value of the property
     */
    void firePropertyChange(String name, Object oldValue, Object newValue);

    /**
     * Register a general {@link java.beans.PropertyChangeListener}.
     *
     * @param listener the listener to register
     */
    void addPropertyChangeListener(java.beans.PropertyChangeListener listener);

    /**
     * Register a  {@link java.beans.PropertyChangeListener}. for the given {@code propertyName}.
     *
     * @param property the property name to listen
     * @param listener the listener to register
     */
    void addPropertyChangeListener(String property, java.beans.PropertyChangeListener listener);

    /**
     * Unregister a general {@link java.beans.PropertyChangeListener}.
     *
     * @param listener the listener to unregister
     */
    void removePropertyChangeListener(java.beans.PropertyChangeListener listener);

    /**
     * Unregister a  {@link java.beans.PropertyChangeListener}. for the given {@code propertyName}.
     *
     * @param property the property name to listen
     * @param listener the listener to unregister
     */
    void removePropertyChangeListener(String property, java.beans.PropertyChangeListener listener);

}
