/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tools.jaxxcapture;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import jaxx.compiler.ClassMap;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tools.jaxxcapture.CapturedObject;
import jaxx.compiler.tools.jaxxcapture.ContextNode;
import jaxx.compiler.tools.jaxxcapture.LiteralNode;
import jaxx.compiler.tools.jaxxcapture.MethodNode;
import jaxx.compiler.tools.jaxxcapture.PropertyNode;
import jaxx.compiler.tools.jaxxcapture.ValueNode;
import jaxx.compiler.tools.jaxxcapture.handlers.JTabbedPaneHandler;
import jaxx.compiler.tools.jaxxcapture.handlers.ObjectHandler;
import jaxx.compiler.tools.jaxxcapture.handlers.TableHandler;
import jaxx.compiler.types.TypeManager;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class JAXXCapture {
    private static ClassMap<Object> objectHandlers = new ClassMap();
    private Map<String, Object> sourceObjects = new HashMap<String, Object>();
    private Map<String, CapturedObject> capturedObjects = new HashMap<String, CapturedObject>();
    private ClassLoader classLoader;
    private int count;

    private JAXXCapture(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<String, CapturedObject> getCapturedObjects() {
        return this.capturedObjects;
    }

    private void applyNames(Component target) {
        String name = target.getName();
        if (name == null || this.sourceObjects.containsKey(name) || !CompiledObject.isValidID(name)) {
            while (this.sourceObjects.containsKey(name = "Object" + ++this.count)) {
            }
        }
        target.setName(name);
        assert (!this.sourceObjects.containsKey(name)) : "ID " + name + " is already registered";
        this.sourceObjects.put(name, target);
        if (target instanceof Container) {
            Container container = (Container)target;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.applyNames(container.getComponent(i));
            }
        }
    }

    public static String getText(Element tag) {
        return ((Text)tag.getChildNodes().item(0)).getData();
    }

    private String getArgumentsCode(ContextNode[] arguments) {
        StringBuffer result = new StringBuffer();
        result.append('(');
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.getJavaCode(arguments[i]));
        }
        result.append(')');
        return result.toString();
    }

    public String getJavaCode(ContextNode node) {
        StringBuffer result = new StringBuffer();
        if (node instanceof PropertyNode) {
            ContextNode[] arguments = node.getArguments();
            result.append(arguments.length == 0 ? "get" : "set");
            result.append(StringUtils.capitalize((String)((PropertyNode)node).getProperty()));
            result.append(this.getArgumentsCode(arguments));
        } else if (node instanceof MethodNode) {
            result.append(((MethodNode)node).getMethodName());
            result.append(this.getArgumentsCode(node.getArguments()));
        } else if (node instanceof CapturedObject) {
            CapturedObject object = (CapturedObject)node;
            if (object.isInlineable()) {
                result.append("new ");
                result.append(object.getClassName());
                result.append(this.getArgumentsCode(node.getArguments()));
            } else {
                String id = object.getProperty("id");
                assert (id != null);
                result.append(id);
            }
        } else if (node instanceof ValueNode) {
            result.append(TypeManager.getJavaCode(((ValueNode)node).getValue()));
        } else if (node instanceof LiteralNode) {
            result.append(((LiteralNode)node).getJavaCode());
        } else {
            throw new IllegalArgumentException("unrecognized node type: " + node);
        }
        return result.toString();
    }

    private static Method getMethod(Class<?> target, String methodName, Class<?>[] arguments) {
        try {
            Class<?> reflectionUtils = Class.forName("java.beans.ReflectionUtils");
            Method getMethod = reflectionUtils.getDeclaredMethod("getMethod", Class.class, String.class, Class[].class);
            getMethod.setAccessible(true);
            return (Method)getMethod.invoke(null, target, methodName, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> target, Class<?>[] arguments) {
        try {
            Class<?> reflectionUtils = Class.forName("java.beans.ReflectionUtils");
            Method getConstructor = reflectionUtils.getDeclaredMethod("getConstructor", Class.class, Class[].class);
            getConstructor.setAccessible(true);
            return (Constructor)getConstructor.invoke(null, target, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object createInstance(CapturedObject object) {
        try {
            ContextNode[] argumentNodes = object.getArguments();
            Object[] arguments = new Object[argumentNodes.length];
            Class[] argumentTypes = new Class[argumentNodes.length];
            for (int j = 0; j < argumentNodes.length; ++j) {
                if (argumentNodes[j] instanceof ValueNode) {
                    arguments[j] = ((ValueNode)argumentNodes[j]).getValue();
                    argumentTypes[j] = arguments[j] != null ? arguments[j].getClass() : null;
                    continue;
                }
                if (!(argumentNodes[j] instanceof CapturedObject)) continue;
                arguments[j] = this.createInstance((CapturedObject)argumentNodes[j]);
                argumentTypes[j] = arguments[j] != null ? arguments[j].getClass() : null;
            }
            Constructor<?> constructor = JAXXCapture.getConstructor(Class.forName(object.getClassName(), true, this.classLoader), argumentTypes);
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getJavaCode(Stack context) {
        Object contextObject;
        CapturedObject contextCapturedObject = (CapturedObject)context.get(0);
        StringBuffer result = new StringBuffer();
        int start = 1;
        for (int i = context.size() - 1; i > 1; --i) {
            if (!(context.get(i) instanceof CapturedObject)) continue;
            start = i;
            contextCapturedObject = (CapturedObject)context.get(i);
            break;
        }
        Class<?> contextClass = (contextObject = this.sourceObjects.get(contextCapturedObject.getProperty("id"))) != null ? contextObject.getClass() : null;
        for (int i = start; i < context.size(); ++i) {
            ContextNode node = (ContextNode)context.get(i);
            if (contextObject != null && (node instanceof MethodNode || node instanceof PropertyNode)) {
                try {
                    ContextNode[] argumentNodes = node.getArguments();
                    String methodName = node instanceof MethodNode ? ((MethodNode)node).getMethodName() : (argumentNodes.length == 0 ? "get" : "set") + StringUtils.capitalize((String)((PropertyNode)node).getProperty());
                    Object[] arguments = new Object[argumentNodes.length];
                    Class[] argumentTypes = new Class[argumentNodes.length];
                    for (int j = 0; j < argumentNodes.length; ++j) {
                        if (argumentNodes[j] instanceof ValueNode) {
                            arguments[j] = ((ValueNode)argumentNodes[j]).getValue();
                            argumentTypes[j] = arguments[j] != null ? arguments[j].getClass() : null;
                            continue;
                        }
                        if (argumentNodes[j] instanceof CapturedObject) {
                            arguments[j] = this.createInstance((CapturedObject)argumentNodes[j]);
                            argumentTypes[j] = arguments[j].getClass();
                            continue;
                        }
                        if (argumentNodes[j] instanceof LiteralNode) {
                            arguments[j] = ((LiteralNode)argumentNodes[j]).getValue();
                            argumentTypes[j] = arguments[j].getClass();
                            continue;
                        }
                        throw new IllegalArgumentException("unsupported argument type: " + argumentNodes[j]);
                    }
                    Method method = JAXXCapture.getMethod(contextClass, methodName, argumentTypes);
                    if (method == null) {
                        result.insert(0, "((" + this.getOutputName(contextObject.getClass()) + ") ");
                        result.append(')');
                        method = JAXXCapture.getMethod(contextObject.getClass(), methodName, argumentTypes);
                    }
                    if (method == null) {
                        throw new RuntimeException("could not find method " + methodName + Arrays.asList(argumentTypes) + " in " + contextObject.getClass() + " (context: " + context + ")");
                    }
                    contextObject = method.invoke(contextObject, arguments);
                    contextClass = method.getReturnType();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (i > start) {
                result.append('.');
            }
            result.append(this.getJavaCode(node));
        }
        return result + ";";
    }

    private String getOutputName(Class<?> c) {
        return c.getName();
    }

    public CapturedObject processObject(Element objectTag, Stack<ContextNode> context) {
        ObjectHandler handler;
        String className = objectTag.getAttribute("class");
        if (className.length() > 0) {
            try {
                ClassDescriptor descriptor = ClassDescriptorLoader.getClassDescriptor(className, this.classLoader);
                handler = (ObjectHandler)objectHandlers.get(descriptor);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            handler = (ObjectHandler)objectHandlers.get(ClassDescriptorLoader.getClassDescriptor(Object.class));
        }
        return handler.processObject(objectTag, context, this);
    }

    private synchronized String convertToJAXX(InputStream beansXML) throws IOException {
        try {
            Document document = JAXXCompiler.parseDocument(beansXML);
            Element rootElement = document.getDocumentElement();
            NodeList nodes = rootElement.getChildNodes();
            Stack<ContextNode> context = new Stack<ContextNode>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node child = nodes.item(i);
                if (child.getNodeType() != 1) continue;
                Element element = (Element)child;
                if (!element.getTagName().equals("object")) {
                    throw new Error("expected tag 'object', found '" + element.getTagName() + "'");
                }
                CapturedObject root = this.processObject(element, context);
                for (CapturedObject object : this.capturedObjects.values()) {
                    if (object.getParent() != null || object == root) continue;
                    root.addChild(object, null);
                }
                String string = root.getXML(this);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.sourceObjects.clear();
        this.capturedObjects.clear();
        this.count = 0;
    }

    public static void main(String[] arg) throws Exception {
        File file = new File(arg[0]);
        JarFile jarFile = new JarFile(file);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
        Thread.currentThread().setContextClassLoader(classLoader);
        EventQueue systemQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        systemQueue.push(new CaptureEventQueue(classLoader));
        Manifest mf = jarFile.getManifest();
        String mainClassName = mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        Class<?> mainClass = Class.forName(mainClassName, true, classLoader);
        Method main = mainClass.getMethod("main", String[].class);
        main.invoke(null, new Object[]{new String[0]});
    }

    static {
        objectHandlers.put(ClassDescriptorLoader.getClassDescriptor(Object.class), (Object)new ObjectHandler());
        objectHandlers.put(ClassDescriptorLoader.getClassDescriptor(JTabbedPane.class), (Object)new JTabbedPaneHandler());
        try {
            objectHandlers.put(ClassDescriptorLoader.getClassDescriptor("jaxx.runtime.swing.Table"), (Object)new TableHandler());
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    private static class CaptureEventQueue
    extends EventQueue {
        private ClassLoader classLoader;

        private CaptureEventQueue(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public void dispatchEvent(AWTEvent event) {
            if (event.getID() == 501 && ((MouseEvent)event).isControlDown()) {
                Component target = ((MouseEvent)event).getComponent();
                if (!(target instanceof Window)) {
                    target = SwingUtilities.getWindowAncestor(target);
                }
                if (target instanceof JFrame) {
                    target = ((JFrame)target).getContentPane();
                } else if (target instanceof JDialog) {
                    target = ((JDialog)target).getContentPane();
                }
                if (target instanceof JWindow) {
                    target = ((JWindow)target).getContentPane();
                }
                if (target != null) {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    JAXXCapture capture = new JAXXCapture(this.classLoader);
                    capture.applyNames(target);
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    XMLEncoder encoder = new XMLEncoder(buffer);
                    encoder.writeObject(target);
                    encoder.close();
                    try {
                        System.err.println(new String(buffer.toByteArray()));
                        System.out.println(capture.convertToJAXX(new ByteArrayInputStream(buffer.toByteArray())));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            super.dispatchEvent(event);
        }
    }
}

