package jaxx.compiler.binding;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.finalizers.DefaultFinalizer;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.binding.DefaultJAXXBinding;

import static java.lang.reflect.Modifier.PUBLIC;
import java.util.List;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision:  $
 *          <p/>
 *          Mise a jour: $Date:  $ par :
 *          $Author: tchemit $
 */
public class DefaultJAXXBindingWriter extends AbstractJAXXBindingWriter<DefaultJAXXBinding> {

    public DefaultJAXXBindingWriter() {
        super(DefaultJAXXBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        return true;
    }

    @Override
    public void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        String eol = JAXXCompiler.getLineSeparator();

        StringBuilder addBuffer = new StringBuilder();
        StringBuilder removeBuffer = new StringBuilder();

        for (DataListener tracker : trackers) {
            boolean needTest = tracker.getObjectCode() != null;
            if (needTest) {
                addBuffer.append("if (").append(tracker.getObjectCode()).append(" != null) {").append(eol);
                removeBuffer.append("if (").append(tracker.getObjectCode()).append(" != null) {").append(eol);
            }
            addBuffer.append(JavaFileGenerator.indent(tracker.getAddListenerCode(), needTest ? 4 : 0, false, eol));
            removeBuffer.append(JavaFileGenerator.indent(tracker.getRemoveListenerCode(), needTest ? 4 : 0, false, eol));
            if (needTest) {
                addBuffer.append(eol).append("}");
                removeBuffer.append(eol).append("}");
            }
            addBuffer.append(eol);
            removeBuffer.append(eol);
        }

        List<JavaMethod> bMethods = binding.getMethods();
        bMethods.add(0, JavaFileGenerator.newMethod(PUBLIC, DefaultFinalizer.TYPE_VOID, DefaultFinalizer.METHOD_NAME_REMOVE_DATA_BINDING, removeBuffer.toString(), true));
        bMethods.add(0, JavaFileGenerator.newMethod(PUBLIC, DefaultFinalizer.TYPE_VOID, DefaultFinalizer.METHOD_NAME_PROCESS_DATA_BINDING, binding.getProcessDataBinding(), true));
        bMethods.add(0, JavaFileGenerator.newMethod(PUBLIC, DefaultFinalizer.TYPE_VOID, DefaultFinalizer.METHOD_NAME_APPLY_DATA_BINDING, addBuffer.toString(), true));

        writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }

    @Override
    protected String getConstructorParams(DataBinding binding, DataListener[] trackers) {
        return "this, " + binding.getConstantId() + ", true";
    }
}
