/*
 * *##% 
 * JAXX Compiler
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.compiler;

import jaxx.compiler.java.JavaFile;

/**
 *
 * Contract of compiled object decorator at generation time.
 *
 * Note : The implementation of this class must be stateless.
 * 
 * @author tony
 * @since 1.2
 */
public interface CompiledObjectDecorator {

    /**
     *
     * @return the name of the decorator (match the content of a decorator
     * attribute value in a JAXX file)
     */
    String getName();

    /**
     *
     * @param compiler
     * @param object
     * @param javaFile
     * @param initDataBindings
     * @return
     */
    String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile, StringBuffer initDataBindings);

    /**
     *
     * @param compiler
     * @param root
     * @param object
     * @param code
     * @param lastWasMethodCall
     * @return
     */
    boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuffer code, boolean lastWasMethodCall);

    /**
     *
     * @param compiler
     * @param root
     * @param object
     * @param javaFile
     * @param packageName
     * @param className
     * @param fullClassName
     */
    void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName);

    /**
     *
     * @param compiler
     * @param object
     * @return
     * @throws CompilerException
     */
    String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException;
}
