/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.types;

import jaxx.compiler.JAXXCompiler;

public class PrimitiveConverter implements TypeConverter {
    public String getJavaCode(Object object) {
        if (object instanceof Boolean) {
            return String.valueOf(((Boolean) object).booleanValue());
        }
        if (object instanceof Byte) {
            return String.valueOf(((Byte) object).byteValue());
        }
        if (object instanceof Short) {
            return String.valueOf(((Short) object).shortValue());
        }
        if (object instanceof Integer) {
            return String.valueOf(((Integer) object).intValue());
        }
        if (object instanceof Long) {
            return String.valueOf(((Long) object).longValue()) + "L";
        }
        if (object instanceof Float) {
            return String.valueOf(((Float) object).floatValue()) + "F";
        }
        if (object instanceof Double) {
            return String.valueOf(((Double) object).doubleValue());
        }
        if (object instanceof String) {
            return '"' + JAXXCompiler.escapeJavaString((String) object) + '"';
        }
        throw new IllegalArgumentException("unsupported object: " + object);
    }


    public Object convertFromString(String string, Class type) {
        if (type == String.class || type == Object.class || type == null) {
            return string;
        }
        if (type == int.class || type == Integer.class) {
            return Integer.valueOf(string);
        }
        if (type == boolean.class || type == Boolean.class) {
            if (string.toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (string.toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("expected 'true' or 'false', found '" + string + "'");
        }
        if (type == byte.class || type == Byte.class) {
            return Byte.valueOf(string);
        }
        if (type == short.class || type == Short.class) {
            return Short.valueOf(string);
        }
        if (type == long.class || type == Long.class) {
            return Long.valueOf(string);
        }
        if (type == float.class || type == Float.class) {
            return Float.valueOf(string);
        }
        if (type == double.class || type == Double.class) {
            return Double.valueOf(string);
        }
        if (type == char.class || type == Character.class) {
            if (string.length() == 1) {
                return string.charAt(0);
            }
            throw new IllegalArgumentException("expected a single character, found '" + string + "'");
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }
}