package jaxx.reflect;

import jaxx.compiler.JAXXCompiler;

/**
 * Mirrors the class <code>java.lang.ref.Method</code>.  JAXX uses <code>ClassDescriptor</code> instead of <code>Class</code>
 * almost everywhere so that it can handle circular dependencies (there can't be a <code>Class</code> object for an uncompiled
 * JAXX or Java source file, and a compiler must be allow references to symbols in uncompiled source files in order to handle
 * circular dependencies).
 */
public class MethodDescriptor extends MemberDescriptor {
    private String returnType;
    private String[] parameterTypes;


    public MethodDescriptor(String name, int modifiers, String returnType, String[] parameterTypes, ClassLoader classLoader) {
        super(name, modifiers, classLoader);
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        if (JAXXCompiler.STRICT_CHECKS && java.util.Arrays.asList(parameterTypes).contains(null)) {
            throw new NullPointerException(name);
        }
    }


    public ClassDescriptor getReturnType() {
        try {            
            //TC 20090228 : fix bug when no return type defined (constructor method)
            if (returnType == null) {
                return null;
            }
            return ClassDescriptorLoader.getClassDescriptor(returnType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find return type " + returnType, e);
        }
    }


    public ClassDescriptor[] getParameterTypes() {
        ClassDescriptor[] result = new ClassDescriptor[parameterTypes.length];
        try {
            for (int i = 0; i < result.length; i++) {
                if (parameterTypes[i] != null) {
                    result[i] = ClassDescriptorLoader.getClassDescriptor(parameterTypes[i], getClassLoader());
                }
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not find the parameter types " + java.util.Arrays.toString(parameterTypes), e);
        }
    }
}