package jaxx.introspection;

import jaxx.reflect.ClassDescriptor;

import java.util.HashMap;
import java.util.Map;

/**
 * Mirrors the class <code>java.beans.FeatureDescriptor</code>.  JAXX uses its own introspector rather than the built-in
 * <code>java.beans.Introspector</code> so that it can introspect {@link jaxx.reflect.ClassDescriptor},
 * not just <code>java.lang.Class</code>.
 */
public class JAXXFeatureDescriptor {
    private String name;
    private Map<String, Object> values;
    private ClassDescriptor classDescriptor;


    JAXXFeatureDescriptor(ClassDescriptor classDescriptor, String name) {
        if (name == null || classDescriptor == null)
            throw new NullPointerException();
        this.name = name;
        this.classDescriptor = classDescriptor;
    }


    public String getName() {
        return name;
    }


    public ClassDescriptor getClassDescriptor() {
        return classDescriptor;
    }


    public Object getValue(String key) {
        return values != null ? values.get(key) : null;
    }


    public void setValue(String key, Object value) {
        if (values == null)
            values = new HashMap<String, Object>();
        values.put(key, value);
    }


    public static String capitalize(String name) {
        if (name.length() == 0)
            return name;
        else
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}
