package jaxx.introspection;

import jaxx.reflect.ClassDescriptor;

/**
 * Mirrors the class <code>java.beans.BeanDescriptor</code>.  JAXX uses its own introspector rather than the built-in
 * <code>java.beans.Introspector</code> so that it can introspect {@link jaxx.reflect.ClassDescriptor},
 * not just <code>java.lang.Class</code>.
 */
public class JAXXBeanDescriptor extends JAXXFeatureDescriptor {
    public JAXXBeanDescriptor(ClassDescriptor beanClass) {
        super(beanClass, beanClass.getName());
    }
}