package jaxx.compiler;

import jaxx.compiler.CompiledObject.ChildRef;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.validator.BeanValidatorHandler;
import jaxx.tags.validator.BeanValidatorHandler.CompiledBeanValidator;
import jaxx.types.TypeManager;

import java.util.List;

/** @author chemit */
public class ValidatorGenerator implements Generator {

    protected static final JavaField VALIDATOR_IDS_FIELD = JavaField.newField(java.lang.reflect.Modifier.PROTECTED,
            "java.util.List<String>", "validatorIds", "new ArrayList<String>()"
    );

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {

        if (!BeanValidatorHandler.hasValidator(compiler)) {
            return;
        }

        for (CompiledObject object : compiler.getObjects().values()) {
            List<ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) {
                continue;
            }
            for (ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                // some validators are defined on this object
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (found) {
                    // box the child component in a JxLayer
                    child.setChildJavaCode(jaxx.runtime.SwingUtil.class.getName()+".boxComponentWithJxLayer(" + javaCode + ")");
                }
            }
        }
        // register validator
        for (CompiledBeanValidator validator : BeanValidatorHandler.getValidators(compiler)) {
            String id = TypeManager.getJavaCode(validator.getId());
            compiler.appendLateInitializer("validatorIds.add(" + id + ");");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
            compiler.appendLateInitializer("getValidator(" + id + ").installUIs();");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
            compiler.appendLateInitializer("getValidator(" + id + ").reloadBean();");
            //compiler.appendLateInitializer("getValidator(" + id + ").validate();");
            compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
        }
        compiler.appendLateInitializer("validatorIds = java.util.Collections.unmodifiableList(validatorIds);");
        compiler.appendLateInitializer(JAXXCompiler.getLineSeparator());
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        if (!BeanValidatorHandler.hasValidator(compiler)) {
            return;
        }
        Class<?> validatorClass = compiler.getOptions().getValidatorClass();
        String validatorFQN = validatorClass.getName();
        javaFile.addImport(validatorFQN);

        //TODO use the specific JAXXValidator interface (swing, gwt,...)
        Class<?> validatorInterface = jaxx.runtime.JAXXValidator.class;

        if (javaFile.isSuperclassIsJAXXObject()) {
            ClassDescriptor superClass = ClassDescriptorLoader.getClassDescriptor(javaFile.getSuperClass());
            boolean parentIsValidator = ClassDescriptorLoader.getClassDescriptor(validatorInterface).isAssignableFrom(superClass);

            if (parentIsValidator) {
                // nothing to generate (use the parent directly)
                return;
            }
        }

        // add JAXXValidator interface
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));

        // implements JAXXValidator
        javaFile.addField(VALIDATOR_IDS_FIELD);
        javaFile.addMethod(JavaMethod.newMethod(java.lang.reflect.Modifier.PUBLIC, validatorFQN + "<?>", "getValidator",
                "return (" + validatorFQN + ") (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);",
                new JavaArgument("String", "validatorId")
        ));
    }

}
