package jaxx.compiler;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.File;

/**
 * Stores options which affect the jaxxc tool's operation.  These options are generally specified by the
 * user on the command line.
 */
public class CompilerOptions {
    private File targetDirectory;
    private File javacTargetDirectory;
    private String classPath;
    private String javacOpts;
    private boolean keepJavaFiles;
    private boolean optimize;
    private boolean verbose;
    private boolean profile;
    /** a flag to enable or disable i18n generation */
    private boolean i18nable;

    /** a flag to add or not logger on generated jaxx files */
    private boolean addLogger;

    /** a flag to not reset compiler after a compile */
    private boolean resetAfterCompile;

    /** the name of implementation of {@link jaxx.runtime.JAXXContext} to be used on {@link jaxx.runtime.JAXXObject}. */
    protected String jaxxContextImplementorClass;

    /** list of fqn of class toimport for all generated jaxx files */
    protected String[] extraImports;

    /** default error ui */
    private Class<?> defaultErrorUI;

    private ClassLoader classLoader;

    private Class<? extends JAXXCompiler> compilerClass;

    /**
     * @deprecated prefer use {@link #validatorClass}
     */
    @Deprecated
    private String validatorFQN;
    /**
     * the validator class to use.
     *
     * @since 1.6.0
     */
    private Class<?> validatorClass;

    /** a flag to use {@link javax.swing.UIManager} to retreave icons. */
    private boolean useUIManagerForIcon;

    /** a flag to generate javax help for any */
    private boolean generateHelp;
    
    private String helpBrokerFQN;    
    /**
     * The prefix to add to i18n key for any help i18n key.
     *
     * @since 1.3
     */
    protected String helpsetI18nPrefix;
    /**
     * The suffix to add to i18n key for an help Id.
     *
     * @since 1.3
     */
    protected String helpsetTitleI18nSuffix;
    /**
     * The suffix to add to i18n key for an toc Id.
     *
     * @since 1.3
     */
    protected String helpsetTocI18nSuffix;
    /**
     * The suffix to add to i18n key for an toc Id.
     *
     * @since 1.3
     */
    protected String helpsetIndexI18nSuffix;
    /**
     * The helpset name
     *
     * @since 1.3
     */
    protected String helpSetName;
    /** the default compiled object decorator to use if none specifed via decorator attribute */
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    
    /**
     * Returns the target directory, generally specified with the "-d" option on the command line.
     *
     * @return the target directory
     * @see #setTargetDirectory
     */
    public File getJavacTargetDirectory() {
        if (javacTargetDirectory == null) {
            // to use the old way : if javacTargetDirectory not specified,
            // use same directory as targetDirectory (says where the java sources
            // are generated)
            return targetDirectory;
        }
        return javacTargetDirectory;
    }

    /**
     * Returns the target directory, generally specified with the "-d" option on the command line.
     *
     * @return the target directory
     * @see #setTargetDirectory
     */
    public File getTargetDirectory() {
        return targetDirectory;
    }


    /**
     * Sets the target directory into which compiled classes will be placed.
     *
     * @param targetDirectory the target directory
     * @see #getTargetDirectory
     */
    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setJavacTargetDirectory(File javacTargetDirectory) {
        this.javacTargetDirectory = javacTargetDirectory;
    }

    /**
     * Returns the class path to be used during compilation.
     *
     * @return the class path to be used during compilation
     * @see #setClassPath
     */
    public String getClassPath() {
        return classPath;
    }

    /**
     * Sets the class path to be used during compilation.
     *
     * @param classPath the compilation class path
     * @see #getClassPath
     */
    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }


    /**
     * Returns the  options to be passed into <code>javac</code>.
     *
     * @return options to be passed into <code>javac</code>
     * @see #setJavacOpts
     */
    public String getJavacOpts() {
        return javacOpts;
    }


    /**
     * Sets options to be passed into <code>javac</code>.
     *
     * @param javacOpts options to be passed into <code>javac</code>
     * @see #getJavacOpts
     */
    public void setJavacOpts(String javacOpts) {
        this.javacOpts = javacOpts;
    }


    /**
     * Returns whether or not generated Java files should be preserved after compilation.
     *
     * @return <code>true</code> if generated Java files should be preserved, <code>false</code> to delete
     * @see #setKeepJavaFiles
     */
    public boolean getKeepJavaFiles() {
        return keepJavaFiles;
    }


    /**
     * Sets whether or not generated Java files should be preserved after compilation.
     *
     * @param keepJavaFiles <code>true</code> if generated Java files should be preserved, <code>false</code> to delete
     * @see #getKeepJavaFiles
     */
    public void setKeepJavaFiles(boolean keepJavaFiles) {
        this.keepJavaFiles = keepJavaFiles;
    }


    /**
     * Returns whether or not optimization should be performed.
     *
     * @return whether or not optimizations should be performed
     */
    public boolean getOptimize() {
        return optimize;
    }


    /**
     * Sets whether or not optimizations should be performed.
     *
     * @param optimize <code>true</code> to perform optimizations during compilation
     * @see #getOptimize
     */
    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean isVerbose() {
        return verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isI18nable() {
        return i18nable;
    }

    public boolean isUseUIManagerForIcon() {
        return useUIManagerForIcon;
    }

    public void setI18nable(boolean i18nable) {
        this.i18nable = i18nable;
    }

    public boolean isAddLogger() {
        return addLogger;
    }

    public void setAddLogger(boolean addLogger) {
        this.addLogger = addLogger;
    }

    public String getJaxxContextImplementorClass() {
        return jaxxContextImplementorClass;
    }

    public void setJaxxContextImplementorClass(String jaxxContextImplementorClass) {
        this.jaxxContextImplementorClass = jaxxContextImplementorClass;
    }

    public String[] getExtraImports() {
        return extraImports;
    }

    public void setExtraImports(String[] extraImports) {
        this.extraImports = extraImports;
    }

    public boolean isResetAfterCompile() {
        return resetAfterCompile;
    }

    public void setResetAfterCompile(boolean resetAfterCompile) {
        this.resetAfterCompile = resetAfterCompile;
    }

    public void setUseUIManagerForIcon(boolean useUIManagerForIcon) {
        this.useUIManagerForIcon = useUIManagerForIcon;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    public void setDefaultErrorUI(Class<?> defaultErrorUI) {
        this.defaultErrorUI = defaultErrorUI;
    }

    public boolean isKeepJavaFiles() {
        return keepJavaFiles;
    }

    public boolean isOptimize() {
        return optimize;
    }

    public Class<?> getDefaultErrorUI() {
        return defaultErrorUI;
    }

    public ClassLoader getClassLoader() {
        return classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<? extends JAXXCompiler> getCompilerClass() {
        return compilerClass;
    }

    public void setCompilerClass(Class<? extends JAXXCompiler> compilerClass) {
        this.compilerClass = compilerClass;
    }

    @Deprecated
    public String getValidatorFQN() {
        return validatorClass.getName();
    }
    
    @Deprecated
    public void setValidatorFQN(String validatorFQN) {
        this.validatorFQN = validatorFQN;
    }

    public Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass() {
        return defaultDecoratorClass;
    }

    public void setDefaultDecoratorClass(Class<? extends CompiledObjectDecorator> defaultDecoratorClass) {
        this.defaultDecoratorClass = defaultDecoratorClass;
    }

    public boolean isProfile() {
        return profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isGenerateHelp() {
        return generateHelp;
    }

    public void setGenerateHelp(boolean generateHelp) {
        this.generateHelp = generateHelp;
    }

    public String getHelpBrokerFQN() {
        return helpBrokerFQN;
    }

    public void setHelpBrokerFQN(String helpBrokerFQN) {
        this.helpBrokerFQN = helpBrokerFQN;
    }

    public String getHelpsetIndexI18nSuffix() {
        return helpsetIndexI18nSuffix;
    }

    public void setHelpsetIndexI18nSuffix(String helpsetIndexI18nSuffix) {
        this.helpsetIndexI18nSuffix = helpsetIndexI18nSuffix;
    }

    public String getHelpsetTitleI18nSuffix() {
        return helpsetTitleI18nSuffix;
    }

    public void setHelpsetTitleI18nSuffix(String helpsetTitleI18nSuffix) {
        this.helpsetTitleI18nSuffix = helpsetTitleI18nSuffix;
    }

    public String getHelpsetTocI18nSuffix() {
        return helpsetTocI18nSuffix;
    }

    public void setHelpsetTocI18nSuffix(String helpsetTocI18nSuffix) {
        this.helpsetTocI18nSuffix = helpsetTocI18nSuffix;
    }

    public String getHelpSetName() {
        return helpSetName;
    }

    public void setHelpSetName(String helpSetName) {
        this.helpSetName = helpSetName;
    }

    public String getHelpsetI18nPrefix() {
        return helpsetI18nPrefix;
    }

    public void setHelpsetI18nPrefix(String helpsetI18nPrefix) {
        this.helpsetI18nPrefix = helpsetI18nPrefix;
    }

    public Class<?> getValidatorClass() {
        return validatorClass;
    }

    public void setValidatorClass(Class<?> validatorClass) {
        this.validatorClass = validatorClass;
    }



}
