package org.nuiton.jaxx.application.swing.action;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;

public class ApplicationActionUI extends JDialog implements ApplicationUI<ApplicationActionUIModel, ApplicationActionUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVWzW8bRRQfu7FT24Tmg0atSJALHBypWvcAXBJBk5SIRC5UpJUqfOmsd2pPO95ZZt42a0VF8B9woef23gsSN06IA2cOXBD/AkIcuCLezK69/tgQt1bbyBmt38fv/d6b99766Z+koBW5dI9GkaNCH3iXOQfbt29/5t5jLbjGdEvxAKQi8V8uT/JNUvEGcg3knWbDuNcT9/qu7AbSZ/6Q92aDlDX0BNMdxgDI+qhHS+v64UC9GQWh6qMOSGWhPv77r/y33tdP8oREAbIrYyrV07zSTOYaJM89IMsY6QGtC+q3kYbifhv5LhjZrqBaf0q77EvyFZlvkGJAFYIBeXv6lC2G9Y8CIKV3D65xKmT7CpAtqdqOH3KQvmNZ0yAQvEWBo0AfIQ+HtuyX7VSxbSW39oPAghaBLLqh7u0I2brfoD2mbu0jvZEixFDWAh8So9S/0JUeE0C2Z6Fz3WCkmCUlJdygvsFdNpWMEoQDKzRWpYFxpS2kS8VA84Y5lgfqpVgdR2pQdxLTCo31+XGnG0q2FdN6hyogF0aJpKpR1xJQff8kMueMcoiKEV80x/qoyRj6WmKiyJsjV4Od76Sdn7ZmrkkKKkQxsm5ODsvnqIrH5MLYmBhAq/13deW3H//4Ya8/G0sY+3ym6dBoY88GSgZMATehz8WDEQIX9es02GySkmYC94Kd+7UMYoeJGslhvCXj7hh35xOqOwhRmP/9p59X7/x6huT3SFlI6u1RY7+PVe9gvTpSeFHw0VXL6LWjs3gu4v8ZIAtu0r+7Uki8TOe4Q31PMOW0GexKH1gEtY34CxqMdHtt4yG2uQUAUjwGFTIUzIea7bfQkxTuUqFZhOVcyyjnICe39Ms/K4ffX+2XNIcpXjzRPC1r4QtS5L7gPrMLJ9klmQumEmgWejLdGVlbhGTMfJDMXs2elycqmMPEXak8vFpy6dhnR9WbHATzdqysVov33kbVD4XYeBiFBuU9m6N5+oCMTumzRFu30T7uBtBLgr1/uZp8siNNDvwU8Ra47zFgqst9CjhKc+aW/wd9aEBPQ89jrzzgmruC9Xtl5mqmS+Y5cuv36yTs+O55sRc1vgxfRSEXuX9Xqq59Gb2E3hwON23Oc2Y3mWqFALz/DpW4isrxc7yEKkPIWZHPyqTU0yTYYbzdwZjLW/HiqVLASrohsA8nsHPmLE+Ban4oUPvG++b5QSoh9nJLKmxkb0aowhH+euvMCFIUtCfxYsjrWx4FWnVx1rDlTijTyqmIRvydOR5lI6zOjPAWIvwHlxr8pbgLAAA=";
    private static final Log log = LogFactory.getLog(ApplicationActionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BlockingLayerUI busyBlockLayerUI;
    protected JLabel globalActionLabel;
    protected JPanel globalPanel;
    protected JProgressBar globalProgressBar;
    protected final ApplicationActionUIHandler handler = createHandler();
    protected ApplicationActionUIModel model;
    protected JPanel rootPanel;
    protected JLabel taskActionLabel;
    protected JPanel taskPanel;
    protected JProgressBar taskProgressBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ApplicationActionUI $JDialog0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        public void open(AbstractApplicationAction action) {
          getModel().setAction(action);
        }
    
        public void close() {
          getModel().clear();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ApplicationActionUI(JFrame frame, ApplicationUIContext context) {
        super(frame, true);
                ApplicationUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public ApplicationActionUI() {
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public JLabel getGlobalActionLabel() {
        return globalActionLabel;
    }

    public JPanel getGlobalPanel() {
        return globalPanel;
    }

    public JProgressBar getGlobalProgressBar() {
        return globalProgressBar;
    }

    public ApplicationActionUIHandler getHandler() {
        return handler;
    }

    public ApplicationActionUIModel getModel() {
        return model;
    }

    public JPanel getRootPanel() {
        return rootPanel;
    }

    public JLabel getTaskActionLabel() {
        return taskActionLabel;
    }

    public JPanel getTaskPanel() {
        return taskPanel;
    }

    public JProgressBar getTaskProgressBar() {
        return taskProgressBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToGlobalPanel() {
        if (!allComponentsCreated) {
            return;
        }
        globalPanel.add(globalActionLabel, BorderLayout.CENTER);
        globalPanel.add(globalProgressBar, BorderLayout.SOUTH);
    }

    protected void addChildrenToRootPanel() {
        if (!allComponentsCreated) {
            return;
        }
        rootPanel.add(globalPanel, BorderLayout.NORTH);
        rootPanel.add(taskPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToTaskPanel() {
        if (!allComponentsCreated) {
            return;
        }
        taskPanel.add(taskActionLabel, BorderLayout.CENTER);
        taskPanel.add(taskProgressBar, BorderLayout.SOUTH);
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createGlobalActionLabel() {
        $objectMap.put("globalActionLabel", globalActionLabel = new JLabel());
        
        globalActionLabel.setName("globalActionLabel");
    }

    protected void createGlobalPanel() {
        $objectMap.put("globalPanel", globalPanel = new JPanel());
        
        globalPanel.setName("globalPanel");
        globalPanel.setLayout(new BorderLayout());
    }

    protected void createGlobalProgressBar() {
        $objectMap.put("globalProgressBar", globalProgressBar = new JProgressBar());
        
        globalProgressBar.setName("globalProgressBar");
        globalProgressBar.setIndeterminate(true);
    }

    protected ApplicationActionUIHandler createHandler() {
        return new ApplicationActionUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ApplicationActionUIModel.class));
    }

    protected void createRootPanel() {
        $objectMap.put("rootPanel", rootPanel = new JPanel());
        
        rootPanel.setName("rootPanel");
        rootPanel.setLayout(new BorderLayout());
    }

    protected void createTaskActionLabel() {
        $objectMap.put("taskActionLabel", taskActionLabel = new JLabel());
        
        taskActionLabel.setName("taskActionLabel");
    }

    protected void createTaskPanel() {
        $objectMap.put("taskPanel", taskPanel = new JPanel());
        
        taskPanel.setName("taskPanel");
        taskPanel.setLayout(new BorderLayout());
        taskPanel.setVisible(false);
    }

    protected void createTaskProgressBar() {
        $objectMap.put("taskProgressBar", taskProgressBar = new JProgressBar());
        
        taskProgressBar.setName("taskProgressBar");
        taskProgressBar.setIndeterminate(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add(SwingUtil.boxComponentWithJxLayer(rootPanel), BorderLayout.CENTER);
        addChildrenToRootPanel();
        addChildrenToGlobalPanel();
        addChildrenToTaskPanel();
        
        // apply 9 property setters
        busyBlockLayerUI.setBlockingColor(handler.getContext().getColorBlockingLayer());
        busyBlockLayerUI.setBlock(true);
        globalPanel.setBorder(new TitledBorder((String) null));
        globalActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        taskPanel.setBorder(new TitledBorder((String) null));
        taskActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JDialog0", $JDialog0);
        createBusyBlockLayerUI();
        createModel();
        createRootPanel();
        createGlobalPanel();
        createGlobalActionLabel();
        createGlobalProgressBar();
        createTaskPanel();
        createTaskActionLabel();
        createTaskProgressBar();
        // inline creation of $JDialog0
        setName("$JDialog0");
        SwingUtil.setComponentHeight($JDialog0,200);
        setModal(true);
        setUndecorated(true);
        SwingUtil.setComponentWidth($JDialog0,300);
        
        $completeSetup();
        handler.afterInit(this);
    }

}