/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.plugin.bundle.AbstractMakeI18nBundleMojo;
import org.nuiton.i18n.plugin.bundle.BundleFormatConverter;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class BundleMojo
extends AbstractMakeI18nBundleMojo {
    protected boolean generateDefinitionFile;
    protected String bundleFormatConverter;
    protected Map<String, BundleFormatConverter> bundleFormatConverters;
    protected BundleFormatConverter converter;

    @Override
    public void init() throws Exception {
        super.init();
        this.addResourceDir(this.bundleOutputDir, new String[]{"**/*.properties"});
        if (StringUtils.isNotEmpty((String)this.bundleFormatConverter)) {
            this.converter = this.bundleFormatConverters.get(this.bundleFormatConverter);
            if (this.converter == null) {
                throw new MojoExecutionException("There is no bundleFormatConverter named \"" + this.bundleFormatConverter + "\", known ones are " + this.bundleFormatConverters.keySet());
            }
        }
    }

    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        String version = this.getProject().getVersion();
        version = PluginHelper.removeSnapshotSuffix((String)version);
        String inputEncoding = this.getBundleInputEncoding();
        String outputEncoding = this.getBundleOutputEncoding();
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - resources dir    : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - package name     : " + this.bundleOutputPackage));
            this.getLog().info((CharSequence)("config - bundle name      : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - input  encoding  : " + inputEncoding));
            this.getLog().info((CharSequence)("config - output encoding  : " + outputEncoding));
            if (this.bundleFormatConverter != null) {
                this.getLog().info((CharSequence)("config - format converter : " + this.bundleFormatConverter));
            }
            this.getLog().info((CharSequence)("config - locales          : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - version          : " + version));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = this.getI18nFile(this.outputFolder, this.bundleOutputName, locale, false);
            SortedProperties propertiesOut = new SortedProperties(outputEncoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)("no bundle for locale " + locale));
                continue;
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate bundle for locale " + locale + " from " + urls.length + " i18n resource(s)"));
            }
            ArrayList<String> bundlesUrls = new ArrayList<String>();
            Charset loadEncoding = Charset.forName(inputEncoding);
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut, loadEncoding);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                String str = strPath.substring(index);
                bundlesUrls.add(str);
                buffer.append(',').append(str);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (!bundlesUrls.isEmpty()) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(bundlesUrls.size() + " i18n resource(s) detected"));
                    }
                    for (String u : bundlesUrls) {
                        this.getLog().info((CharSequence)u);
                    }
                }
            }
            if (this.converter != null) {
                this.applyConversion((Properties)propertiesOut);
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, this.unsafeMapping);
        }
        this.failsIfWarning();
        if (this.generateDefaultLocale) {
            this.generateDefaultBundle();
        }
        if (this.generateDefinitionFile) {
            this.generateDefinitionFile(version, bundleDico);
        }
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    @Override
    protected File getBundleFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        return this.getI18nFile(root, artifactId, locale, create);
    }

    protected void generateDefinitionFile(String version, Map<Locale, String> bundleDico) throws IOException {
        String f = String.format(DefaultI18nInitializer.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
        File defOut = new File(this.outputFolder, f);
        if (!this.silent) {
            this.getLog().info((CharSequence)("prepare i18n definition file in " + defOut.getAbsolutePath()));
        }
        SortedProperties p = new SortedProperties(this.encoding, false);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_LOCALES, this.bundles);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_VERSION, version);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_ENCODING, this.encoding);
        for (Map.Entry<Locale, String> e : bundleDico.entrySet()) {
            p.setProperty(DefaultI18nInitializer.BUNDLES_FOR_LOCALE + e.getKey().toString(), e.getValue());
        }
        p.store(defOut);
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        URL[] urls = PluginHelper.getLinesAsURL((File)file);
        return urls;
    }

    protected void applyConversion(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String convertedValue = this.converter.convert((String)entry.getValue());
            properties.setProperty((String)entry.getKey(), convertedValue);
        }
    }
}

