/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.io.SortedProperties;

public abstract class AbstractFileParser
implements FileParser {
    private final Log log;
    private final SortedProperties oldParser;
    private final boolean showTouchedFiles;
    private final SortedProperties result;
    private boolean touched;
    private final String encoding;

    protected AbstractFileParser(Log log, String encoding, SortedProperties oldParser, boolean showTouchedFiles) {
        this.log = log;
        this.oldParser = oldParser;
        this.showTouchedFiles = showTouchedFiles;
        this.encoding = encoding;
        this.result = new SortedProperties(encoding);
    }

    public boolean isShowTouchedFiles() {
        return this.showTouchedFiles;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public SortedProperties getResult() {
        return this.result;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void destroy() {
        this.result.clear();
        this.touched = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public Log getLog() {
        return this.log;
    }

    protected void registerKey(String key) {
        Object value = this.oldParser.get((Object)key);
        if (value == null) {
            value = key;
        }
        this.getResult().put((Object)key, value);
    }

    protected void setTouched(boolean touched) {
        this.touched = touched;
    }

    protected File prepareFile(File file) throws IOException {
        return file;
    }
}

