/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.io.SortedProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ParserXmlMojo
extends AbstractI18nParserMojo {
    protected static final int BUFFER_SIZE = 8192;
    protected String rules;
    protected XPathFactory factory;
    protected DocumentBuilderFactory documentBuilderFactory;

    protected abstract String getFileRules();

    protected abstract String getCoreFileRules();

    protected abstract XmlFileParser newXmlFileParser(XPath var1, DocumentBuilder var2);

    @Override
    public void init() throws Exception {
        super.init();
        this.factory = XPathFactory.newInstance();
        this.rules = this.getRules(this.getFileRules());
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public final FileParser newFileParser() {
        DocumentBuilder builder;
        try {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("could not load DocumentBuilder for reason " + ex.getMessage(), ex);
        }
        XPath xpath = this.factory.newXPath();
        return this.newXmlFileParser(xpath, builder);
    }

    private String getRules(String fileRules) {
        StringBuilder buffer = new StringBuilder();
        try {
            String readInputStream = this.loadRulesFile(this.getCoreFileRules());
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("core rules : " + this.getCoreFileRules()));
            }
            buffer.append(readInputStream);
            if (!fileRules.equals(this.getCoreFileRules())) {
                readInputStream = this.loadRulesFile(fileRules);
                if (!this.silent && this.verbose) {
                    this.getLog().info((CharSequence)("custom rules : " + fileRules));
                }
                buffer.append(" | ").append(readInputStream);
            }
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        return buffer.toString();
    }

    private String loadRulesFile(String fileRules) throws IOException {
        InputStream inputStream;
        File f = new File(fileRules);
        if (f.exists()) {
            try {
                inputStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParserException(e);
            }
        } else {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            inputStream = classLoader.getResourceAsStream(fileRules);
        }
        if (inputStream == null) {
            throw new ParserException("could not found file of rules : " + fileRules);
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            String readInputStream;
            String string = readInputStream = this.readInputStream(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        finally {
            inputStream.close();
        }
    }

    private String readInputStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[8192];
        while (in.read(buffer, 0, 8192) != -1) {
            String tmp = new String(buffer);
            sb.append(tmp);
        }
        in.close();
        String txt = sb.toString().trim();
        txt = txt.replaceAll("#.*\n", "");
        txt = txt.replaceAll("\\s+", " | ");
        txt = txt.replaceAll("(^ \\| )|( \\| $)", "");
        return txt;
    }

    public static abstract class XmlFileParser
    extends AbstractFileParser {
        private final XPath xpath;
        private final String rules;
        private final DocumentBuilder builder;

        public abstract String extract(String var1);

        public XmlFileParser(Log log, String encoding, SortedProperties oldParser, boolean showTouchedFiles, String rules, XPath xpath, DocumentBuilder builder) {
            super(log, encoding, oldParser, showTouchedFiles);
            this.xpath = xpath;
            this.rules = rules;
            this.builder = builder;
        }

        @Override
        public void parseFile(File file) throws IOException {
            try {
                Document doc = this.builder.parse(file.getAbsolutePath());
                XPathExpression expression = this.xpath.compile(this.rules);
                NodeList list = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                for (int index = 0; index < list.getLength(); ++index) {
                    Node node = list.item(index);
                    this.parseLine(file, node.getTextContent());
                }
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
        }

        @Override
        public void parseLine(File file, String key) throws IOException {
            if ((key = this.extract(key)) != null) {
                this.setTouched(true);
                this.registerKey(key);
            }
        }
    }
}

