/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.nuiton.i18n.plugin.parser.AbstractI18nParser;
import org.nuiton.i18n.plugin.parser.ParserEvent;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public abstract class ParserXml
extends AbstractI18nParser {
    protected static final int BUFFER_SIZE = 8192;
    protected File defaultBasedir;
    protected String rules;
    protected XPathFactory factory;
    protected XPath xpath;
    protected DocumentBuilder builder;

    public abstract String extract(String var1);

    protected abstract String getFileRules();

    protected abstract String getCoreFileRules();

    @Override
    public void init() {
        super.init();
        this.factory = XPathFactory.newInstance();
        this.rules = this.getRules(this.getFileRules());
        this.xpath = this.factory.newXPath();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
            EntityResolver resolver = this.getEntityResolver();
            if (resolver != null) {
                this.builder.setEntityResolver(resolver);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("could not load DocumentBuilder for reason " + ex.getMessage(), ex);
        }
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public InputSource getSystemId(String publicId) {
        return null;
    }

    @Override
    public void parseFile(File file) {
        try {
            int size = this.result.size();
            Document doc = this.builder.parse(file.getAbsolutePath());
            XPathExpression expression = this.xpath.compile(this.rules);
            NodeList list = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                this.parseLine(file, node.getTextContent());
            }
            if (this.safeMode && size != this.result.size()) {
                this.saveGetterFile();
            }
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    @Override
    public void parseLine(File file, String key) {
        if ((key = this.extract(key)) != null) {
            this.touchFile = true;
            String keyModified = key;
            for (ParserEvent event : this.events) {
                event.eventChangeKey(key, !this.oldLanguage.containsKey((Object)key));
                keyModified = event.eventGetRealKey();
            }
            if (this.oldParser.containsKey((Object)key)) {
                this.result.put((Object)keyModified, this.oldParser.get((Object)key));
            } else {
                this.result.put((Object)keyModified, (Object)key);
            }
        }
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    private String getRules(String fileRules) {
        StringBuilder buffer = new StringBuilder();
        try {
            String readInputStream = this.loadRulesFile(this.getCoreFileRules());
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("core rules : " + this.getCoreFileRules()));
            }
            buffer.append(readInputStream);
            if (!fileRules.equals(this.getCoreFileRules())) {
                readInputStream = this.loadRulesFile(fileRules);
                if (!this.silent && this.verbose) {
                    this.getLog().info((CharSequence)("custom rules : " + fileRules));
                }
                buffer.append(" | ").append(readInputStream);
            }
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        return buffer.toString();
    }

    private String loadRulesFile(String fileRules) throws IOException {
        InputStream inputStream;
        File f = new File(fileRules);
        if (f.exists()) {
            try {
                inputStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParserException(e);
            }
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            inputStream = classLoader.getResourceAsStream(fileRules);
        }
        if (inputStream == null) {
            throw new ParserException("could not found file of rules : " + fileRules);
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            String readInputStream;
            String string = readInputStream = this.readInputStream(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        finally {
            inputStream.close();
        }
    }

    private String readInputStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[8192];
        while (in.read(buffer, 0, 8192) != -1) {
            String tmp = new String(buffer);
            sb.append(tmp);
        }
        in.close();
        String txt = sb.toString().trim();
        txt = txt.replaceAll("#.*\n", "");
        txt = txt.replaceAll("\\s+", " | ");
        txt = txt.replaceAll("(^ \\| )|( \\| $)", "");
        return txt;
    }
}

