/*
 * *##% Plugin maven pour i18n
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

package org.nuiton.i18n.plugin.parser.impl;

import org.nuiton.util.SourceEntry;
import org.nuiton.util.FileUpdater;
import org.nuiton.util.FileUpdaterHelper;

import java.io.File;

/**
 * Récupération des chaine à traduire depuis les fichiers xml Jaxx.
 *
 * @author julien
 * @goal parserJaxx
 * @phase generate-resources
 * @deprecated since 1.0.0, prefer use the java parser since xml parser can not
 * be easly extendable 
 */
@Deprecated
public class ParserJaxx extends ParserXml {

    /**
     * Source entries (src+includes+excludes) .
     *
     * @parameter expression="${i18n.defaultIncludes}" default-value="**\/*.jaxx"
     */
    protected String defaultIncludes;

    /**
     * Where jaxx files should have been generated.
     *
     * @parameter expression="${i18n.defaultGenerateBasedir}" default-value="${basedir}/target/generated-sources/java"
     */
    protected File defaultGenerateBasedir;

    /**
     * Regles xml.
     *
     * @parameter expression="${i18n.rulesJaxx}" default-value="jaxx.rules"
     */
    protected String rulesJaxx;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return new String[]{};
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater(entry.getBasedir(), defaultGenerateBasedir);
    }

    @Override
    protected String getOutGetter() {
        return "jaxx.getter";
    }

    @Override
    protected String getKeyModifierStart() {
        return "=\\s*[\"\']";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "[\"\']";
    }

    @Override
    protected String getFileRules() {
        return rulesJaxx;
    }

    @Override
    protected String getCoreFileRules() {
        return "jaxx.rules";
    }

    public void setRulesJaxx(String rulesJaxx) {
        this.rulesJaxx = rulesJaxx;
    }

    /*
     * (non-Javadoc)
     * @see org.codelutin.i18n.plugin.extension.XmlParser#extract(java.lang.String)
     */
    @Override
    public String extract(String i18nString) {
        return i18nString.length() == 0 ? null : i18nString;
    }

}
