/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;

@Mojo(name="collect-files", requiresProject=true)
public class CollectFilesMojo
extends AbstractPlugin
implements PluginWithEncoding {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    protected List<?> reactorProjects;
    @Component
    protected MavenProject project;
    @Parameter(property="project.attachedArtifacts", readonly=true, required=true)
    protected List<?> attachedArtifacts;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.distributionManagementArtifactRepository", readonly=true, required=true)
    protected ArtifactRepository deploymentRepository;
    @Parameter(property="project.artifact", readonly=true, required=true)
    protected Artifact artifact;
    @Parameter(property="helper.extraFiles")
    protected String extraFiles;
    @Parameter(property="helper.includes", defaultValue="")
    protected String includes;
    @Parameter(property="helper.excludes", defaultValue="")
    protected String excludes;
    @Parameter(property="helper.outputDirectory", defaultValue="target/collect")
    protected String outputDirectory;
    @Parameter(property="helper.descriptionFile")
    protected String descriptionFile;
    @Parameter(property="helper.includeAttached", defaultValue="true")
    protected boolean includeAttached;
    @Parameter(property="helper.includeSiteAttached", defaultValue="false")
    protected boolean includeSiteAttached;
    @Parameter(property="helper.copyFiles", defaultValue="true")
    protected boolean copyFiles;
    @Parameter(property="helper.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="helper.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="helper.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="helper.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    protected List<File> files;

    protected void init() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.files = this.getFiles();
    }

    protected boolean checkSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on, goal will not be executed.");
            return false;
        }
        if (this.files.isEmpty()) {
            this.getLog().warn((CharSequence)"No file to collect, goal will not be executed.");
            return false;
        }
        return true;
    }

    public void doAction() throws Exception {
        MavenProject rootProject;
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.project));
        }
        if ((rootProject = this.getRootProject(this.project, this.reactorProjects)) == null) {
            throw new MojoFailureException("Could not find root project for " + this.project + " in reactor " + this.reactorProjects);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("root project = " + rootProject));
        }
        File base = new File(rootProject.getBasedir(), this.outputDirectory);
        File output = new File(base, this.project.getGroupId() + "--" + this.project.getArtifactId());
        if (this.verbose) {
            this.getLog().info((CharSequence)("Ouput dir : " + output));
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no file will be copied!\n");
        } else if (this.copyFiles) {
            this.createDirectoryIfNecessary(output);
        }
        File description = null;
        ArrayList<File> incomingFiles = null;
        boolean withDescriptionFile = false;
        if (StringUtils.isNotBlank((CharSequence)this.descriptionFile)) {
            description = new File(rootProject.getBasedir(), this.descriptionFile);
            withDescriptionFile = true;
            if (description.exists()) {
                try {
                    incomingFiles = this.getFiles(description);
                    this.getLog().info((CharSequence)("Loaded " + description));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not load file " + description, (Exception)ex);
                }
            } else {
                incomingFiles = new ArrayList();
            }
        }
        if (!withDescriptionFile && !this.copyFiles) {
            throw new MojoExecutionException("must use at least one of the parameters 'copyFiles' or 'descriptionFile'");
        }
        String basedir = rootProject.getBasedir().getAbsolutePath();
        int basedirLength = basedir.length();
        for (File f : this.files) {
            String absolutePath = f.getAbsolutePath();
            String path = absolutePath.substring(basedirLength + 1);
            File dst = new File(output, f.getName());
            if (withDescriptionFile) {
                if (this.copyFiles) {
                    incomingFiles.add(dst);
                } else {
                    incomingFiles.add(f);
                }
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Collected file " + path));
            }
            if (this.dryRun || !this.copyFiles) continue;
            this.copyFile(f, dst);
        }
        if (!this.dryRun && withDescriptionFile) {
            try {
                this.setFiles(description, incomingFiles);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Saved " + description));
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not save file " + description, (Exception)ex);
            }
        }
    }

    public List<File> getFiles(File input) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(Arrays.asList(PluginHelper.getLinesAsFiles((File)input)));
        return result;
    }

    public void setFiles(File output, List<File> files) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (File f : files) {
            builder.append(f.getAbsolutePath()).append("\n");
        }
        this.writeFile(output, builder.toString(), this.encoding);
    }

    protected List<File> getFiles() {
        File file;
        Pattern includePattern = StringUtils.isBlank((CharSequence)this.includes) ? null : Pattern.compile(this.includes.trim());
        Pattern excludePattern = StringUtils.isBlank((CharSequence)this.excludes) ? null : Pattern.compile(this.excludes.trim());
        ArrayList<File> result = new ArrayList<File>();
        if (this.includeAttached) {
            if ("pom".equals(this.project.getPackaging())) {
                this.addFile(this.project.getFile(), "adding artifact file : ", result, includePattern, excludePattern);
            } else {
                this.addFile(this.artifact.getFile(), "adding artifact file : ", result, includePattern, excludePattern);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.extraFiles)) {
            File basedir = this.project.getBasedir();
            for (String path : this.extraFiles.split(",")) {
                file = (path = path.trim()).startsWith(basedir.getAbsolutePath()) ? new File(path.trim()) : new File(basedir, path.trim());
                this.addFile(file, "adding user file : ", result, includePattern, excludePattern);
            }
        }
        if (this.includeAttached && this.attachedArtifacts != null) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"Will add build attached files.");
            }
            for (Object o : this.attachedArtifacts) {
                file = ((Artifact)o).getFile();
                this.addFile(file, "adding attached artifact file : ", result, includePattern, excludePattern);
            }
        }
        if (this.includeSiteAttached) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"Will add site attached files.");
            }
            for (Object o : this.artifact.getMetadataList()) {
                if (!"SiteDescriptorArtifactMetadata".equals(o.getClass().getSimpleName())) continue;
                String path = this.localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)o, this.deploymentRepository);
                File destination = new File(this.localRepository.getBasedir(), path);
                this.addFile(destination, "adding site descriptor file : ", result, includePattern, excludePattern);
            }
        }
        return result;
    }

    protected void addFile(File f, String msg, List<File> files, Pattern includePattern, Pattern excludePattern) {
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            this.getLog().warn((CharSequence)("skip unexisting file " + f + " (" + msg + ")"));
            return;
        }
        if (excludePattern != null && excludePattern.matcher(f.getName()).matches()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip " + f + " : in excludes " + this.excludes));
            }
            return;
        }
        if (includePattern != null && !includePattern.matcher(f.getName()).matches()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip " + f + " : not in includes " + this.includes));
            }
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)(msg + f));
        }
        files.add(f);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

