/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestDataNotFoundException;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;

@Deprecated
public class RestSession {
    protected HttpClient client;
    protected static final Log log = LogFactory.getLog(RestSession.class);
    protected boolean open;
    protected boolean showRequest;
    protected RestClientConfiguration configuration;

    RestSession(RestClientConfiguration configuration) {
        this.showRequest = configuration.isVerbose();
        this.configuration = configuration;
        this.client = new HttpClient();
        HostConfiguration hostConfiguration = new HostConfiguration();
        int port = configuration.getRestUrl().getPort();
        if (port == -1) {
            hostConfiguration.setHost(configuration.getRestUrl().getHost());
        } else {
            hostConfiguration.setHost(configuration.getRestUrl().getHost(), port);
        }
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)configuration.getEncoding());
        this.client.setHostConfiguration(hostConfiguration);
        this.client.setState(new HttpState());
    }

    public InputStream askData(RestRequest request) throws RestException, IOException {
        if (!this.open) {
            throw new IllegalStateException("the session is not opened");
        }
        HttpMethod gm = this.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode == 404) {
            throw new RestDataNotFoundException("could not retreave some datas : " + gm.getResponseBodyAsString());
        }
        if (statusCode != 200) {
            log.error((Object)("Error = " + gm.getResponseBodyAsString()));
            this.releaseConnection(this.getConnection());
            throw new RestException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
        InputStream stream = gm.getResponseBodyAsStream();
        return stream;
    }

    public InputStream sendData(RestRequest request) throws RestException, IOException {
        if (!this.open) {
            throw new IllegalStateException("the session is not opened");
        }
        HttpMethod gm = this.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode != 200) {
            log.error((Object)gm.getResponseBodyAsString());
            this.releaseConnection(this.getConnection());
            throw new RestException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
        InputStream stream = gm.getResponseBodyAsStream();
        return stream;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void close() throws IOException {
        this.client.getState().clearCookies();
        this.releaseConnection(this.getConnection());
        this.open = false;
    }

    protected void releaseConnection(HttpConnection connection) {
        if (connection != null && connection.isOpen()) {
            this.client.getHttpConnectionManager().releaseConnection(connection);
        }
    }

    protected HttpConnection getConnection() {
        return this.client.getHttpConnectionManager().getConnection(this.client.getHostConfiguration());
    }

    protected String getRequestUrl(RestRequest request) {
        String uri = this.client.getHostConfiguration().getHostURL();
        String result = request.toPath(uri);
        return result;
    }

    public HttpMethod doRequest(RestRequest request) throws IOException {
        Map<String, String> headers;
        HttpMethod gm;
        if (this.showRequest) {
            log.info((Object)("doRequest " + this.getRequestUrl(request)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRequest with parameters : " + Arrays.toString(request.getParameters())));
        }
        switch (request.getMethod()) {
            case GET: {
                gm = this.prepareGetRequest(request);
                break;
            }
            case POST: {
                gm = this.preparePostRequest(request);
                break;
            }
            case PUT: {
                gm = this.preparePutRequest(request);
                break;
            }
            case DELETE: {
                gm = this.prepareDeleteRequest(request);
                break;
            }
            default: {
                throw new IllegalStateException("Can not deal with method " + (Object)((Object)request.getMethod()));
            }
        }
        if (this.open) {
            Cookie[] cookies;
            for (Cookie c : cookies = this.client.getState().getCookies()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("push cookie : " + c.getName() + "=" + c.getValue()));
                }
                gm.addRequestHeader("Cookie", c.toExternalForm());
            }
        }
        if (MapUtils.isNotEmpty(headers = request.getHeaders())) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                gm.addRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        this.client.executeMethod(gm);
        return gm;
    }

    public HttpMethod prepareGetRequest(RestRequest request) throws IOException {
        String uri = this.getRequestUrl(request);
        String[] parameters = request.getParameters();
        Map<String, File> attachments = request.getAttachments();
        if (attachments != null) {
            throw new IllegalStateException("Can not do a GET request with multi-parts, use a POST or UPDATE request");
        }
        GetMethod gm = new GetMethod(uri);
        this.addParams((HttpMethodBase)gm, parameters);
        return gm;
    }

    public HttpMethod prepareDeleteRequest(RestRequest request) throws IOException {
        String uri = this.getRequestUrl(request);
        String[] parameters = request.getParameters();
        Map<String, File> attachments = request.getAttachments();
        if (attachments != null) {
            throw new IllegalStateException("Can not do a DELETE request with multi-parts, use a POST or UPDATE request");
        }
        DeleteMethod gm = new DeleteMethod(uri);
        this.addParams((HttpMethodBase)gm, parameters);
        return gm;
    }

    public HttpMethod preparePostRequest(RestRequest request) throws IOException {
        String uri = this.getRequestUrl(request);
        String[] parameters = request.getParameters();
        Map<String, File> attachments = request.getAttachments();
        PostMethod gm = new PostMethod(uri);
        if (attachments == null) {
            if (parameters.length > 0) {
                int nbParams = parameters.length / 2;
                for (int i = 0; i < nbParams; ++i) {
                    String key = parameters[2 * i];
                    String value = parameters[2 * i + 1];
                    if (value == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("skip null parameter " + key));
                        continue;
                    }
                    gm.addParameter(key, value);
                }
            }
        } else {
            this.prepareMultiPart((EntityEnclosingMethod)gm, attachments, parameters);
        }
        return gm;
    }

    public HttpMethod preparePutRequest(RestRequest request) throws IOException {
        String uri = this.getRequestUrl(request);
        String[] parameters = request.getParameters();
        Map<String, File> attachments = request.getAttachments();
        PutMethod gm = new PutMethod(uri);
        if (attachments == null) {
            this.addParams((HttpMethodBase)gm, parameters);
        } else {
            this.prepareMultiPart((EntityEnclosingMethod)gm, attachments, parameters);
        }
        return gm;
    }

    protected void addParams(HttpMethodBase gm, String ... parameters) {
        if (parameters.length > 0) {
            int nbParams = parameters.length / 2;
            NameValuePair[] params = new NameValuePair[nbParams];
            for (int i = 0; i < nbParams; ++i) {
                String key = parameters[2 * i];
                String value = parameters[2 * i + 1];
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skip null parameter " + key));
                    continue;
                }
                params[i] = new NameValuePair(key, value);
            }
            gm.setQueryString(params);
        }
    }

    protected void prepareMultiPart(EntityEnclosingMethod gm, Map<String, File> attachments, String ... parameters) throws IOException {
        String key;
        ArrayList<Object> paramParts = new ArrayList<Object>();
        if (parameters.length > 0) {
            int nbParams = parameters.length / 2;
            for (int i = 0; i < nbParams; ++i) {
                key = parameters[2 * i];
                String value = parameters[2 * i + 1];
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skip null parameter " + key));
                    continue;
                }
                paramParts.add(new StringPart(key, value));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("add parameter [" + key + "]=" + value));
            }
        }
        for (Map.Entry<String, File> entry : attachments.entrySet()) {
            key = entry.getKey();
            File file = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("add attachment " + key + "=" + file));
            }
            paramParts.add(new FilePart(key, file.getName(), file, "application/octet-stream", this.configuration.getEncoding()));
        }
        if (attachments.isEmpty()) {
            log.warn((Object)"no attachment in a multi-part request!");
        }
        Part[] parts = paramParts.toArray(new Part[paramParts.size()]);
        MultipartRequestEntity entity = new MultipartRequestEntity(parts, gm.getParams());
        if (log.isDebugEnabled()) {
            entity.writeRequest((OutputStream)System.out);
        }
        gm.setRequestEntity((RequestEntity)entity);
        gm.addRequestHeader("content-type", entity.getContentType());
        gm.addRequestHeader("content-length", entity.getContentLength() + "");
        if (this.showRequest) {
            log.info((Object)("content-type : " + entity.getContentType() + ", content-length : " + entity.getContentLength()));
        }
    }
}

