/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.tags.gwt;

import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.tags.gwt.RowHandler;
import org.nuiton.guix.tags.gwt.TableHandler;

public class CellHandler
extends TableHandler {
    private String id = null;
    private int columns = 1;
    private int rows = 1;
    private int row = -1;
    private int column = -1;

    public CellHandler() {
    }

    public CellHandler(GuixModelObject cell) {
        assert (cell.getChildren().size() == 1);
        this.id = ((GuixModelObject)cell.getChildren().get(0)).getId();
        for (AttributeDescriptor attr : cell.getAttributeDescriptors()) {
            if (attr.getName().equals("columns")) {
                this.columns = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("column")) {
                this.column = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("rows")) {
                this.rows = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("weightx")) {
                this.weightx = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("weighty")) {
                this.weighty = Double.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("ipadx")) {
                this.ipadx = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("ipady")) {
                this.ipady = Integer.valueOf(attr.getValue());
                continue;
            }
            if (attr.getName().equals("horizontalAlignment")) {
                this.horizontalAlignment = this.getHalign(attr.getValue());
                continue;
            }
            if (attr.getName().equals("verticalAlignment")) {
                this.verticalAlignment = this.getValign(attr.getValue());
                continue;
            }
            if (attr.getName().equals("fill")) {
                this.fill = attr.getValue();
                continue;
            }
            if (!attr.getName().equals("insets")) continue;
            this.insets = attr.getValue();
        }
    }

    public CellHandler(GuixModelObject cell, RowHandler row) {
        this(cell);
        if (this.horizontalAlignment == null) {
            TableHandler.HorizontalAlignment horizontalAlignment = this.horizontalAlignment = row.getHorizontalAlignment() == null ? TableHandler.DEFAULT_HORIZONTAL_ALIGNMENT : row.getHorizontalAlignment();
        }
        if (this.verticalAlignment == null) {
            TableHandler.VerticalAlignment verticalAlignment = this.verticalAlignment = row.getVerticalAlignment() == null ? TableHandler.DEFAULT_VERTICAL_ALIGNMENT : row.getVerticalAlignment();
        }
        if (this.fill == null) {
            String string = this.fill = row.getFill() == null ? "both" : row.getFill();
        }
        if (this.insets == null) {
            String string = this.insets = row.getInsets() == null ? "3, 3, 3, 3" : row.getInsets();
        }
        if (this.ipadx == null) {
            Integer n = this.ipadx = row.getIpadx() == null ? TableHandler.DEFAULT_IPADX : row.getIpadx();
        }
        if (this.ipady == null) {
            Integer n = this.ipady = row.getIpady() == null ? TableHandler.DEFAULT_IPADY : row.getIpady();
        }
        if (this.weightx == null) {
            Double d = this.weightx = row.getWeightx() == null ? TableHandler.DEFAULT_WEIGHTX : row.getWeightx();
        }
        if (this.weighty == null) {
            Double d = this.weighty = row.getWeighty() == null ? TableHandler.DEFAULT_WEIGHTY : row.getWeighty();
        }
        if (this.row == -1) {
            this.row = row.getRow() < 0 ? -1 : row.getRow();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    @Override
    public Class getClassToGenerate() {
        return null;
    }
}

