/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataUtil;
import org.neo4j.driver.v1.Value;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> runCompletedFuture;
    private List<String> statementKeys = Collections.emptyList();
    private long resultAvailableAfter = -1L;

    public RunResponseHandler(CompletableFuture<Void> runCompletedFuture) {
        this.runCompletedFuture = runCompletedFuture;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.statementKeys = MetadataUtil.extractStatementKeys(metadata);
        this.resultAvailableAfter = MetadataUtil.extractResultAvailableAfter(metadata);
        this.completeRunFuture();
    }

    @Override
    public void onFailure(Throwable error) {
        this.completeRunFuture();
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    public List<String> statementKeys() {
        return this.statementKeys;
    }

    public long resultAvailableAfter() {
        return this.resultAvailableAfter;
    }

    private void completeRunFuture() {
        this.runCompletedFuture.complete(null);
    }
}

