/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import org.apache.jasper.runtime.ELContextImpl;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static Map<ServletContext, JspApplicationContextImpl> map = Collections.synchronizedMap(new HashMap());
    private ArrayList<ELResolver> elResolvers = new ArrayList();
    private ArrayList<ELContextListener> listeners = new ArrayList();
    private ServletContext context;
    private ExpressionFactory expressionFactory;

    public JspApplicationContextImpl(ServletContext context) {
        this.context = context;
        ELResolver beanManagerELResolver = (ELResolver)context.getAttribute("org.glassfish.jsp.beanManagerELResolver");
        if (beanManagerELResolver != null) {
            this.elResolvers.add(beanManagerELResolver);
        }
    }

    public void addELResolver(ELResolver resolver) {
        if ("true".equals(this.context.getAttribute("jspx.1st.request"))) {
            throw new IllegalStateException("Attempt to invoke addELResolver after the application has already received a request");
        }
        this.elResolvers.add(0, resolver);
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = ExpressionFactory.newInstance();
        }
        return this.expressionFactory;
    }

    public void addELContextListener(ELContextListener listener) {
        this.listeners.add(listener);
    }

    protected ELContext createELContext(ELResolver resolver) {
        ELContextImpl elContext = new ELContextImpl(resolver);
        for (ELContextListener elcl : this.listeners) {
            elcl.contextCreated(new ELContextEvent((ELContext)elContext));
        }
        return elContext;
    }

    protected static JspApplicationContextImpl findJspApplicationContext(ServletContext context) {
        JspApplicationContextImpl jaContext = map.get(context);
        if (jaContext == null) {
            jaContext = new JspApplicationContextImpl(context);
            map.put(context, jaContext);
        }
        return jaContext;
    }

    public static void removeJspApplicationContext(ServletContext context) {
        map.remove(context);
    }

    protected Iterator<ELResolver> getELResolvers() {
        return this.elResolvers.iterator();
    }
}

