/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlusDecorator
implements ServletContextHandler.Decorator {
    private static final Logger LOG = Log.getLogger(PlusDecorator.class);
    protected WebAppContext _context;

    public PlusDecorator(WebAppContext context) {
        this._context = context;
    }

    @Override
    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
    }

    @Override
    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        this.decorate(filter);
        return filter;
    }

    @Override
    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        this.decorate(listener);
        return listener;
    }

    @Override
    public void decorateServletHolder(ServletHolder holder) throws ServletException {
        this.decorate(holder);
    }

    @Override
    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        this.decorate(servlet);
        return servlet;
    }

    @Override
    public void destroyFilterInstance(Filter f) {
        this.destroy(f);
    }

    @Override
    public void destroyServletInstance(Servlet s) {
        this.destroy(s);
    }

    @Override
    public void destroyListenerInstance(EventListener l) {
        this.destroy(l);
    }

    protected void decorate(Object o) throws ServletException {
        LifeCycleCallbackCollection callbacks;
        InjectionCollection injections;
        RunAsCollection runAses = (RunAsCollection)this._context.getAttribute("org.eclipse.jetty.runAsCollection");
        if (runAses != null) {
            runAses.setRunAs(o);
        }
        if ((injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection")) != null) {
            injections.inject(o);
        }
        if ((callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            try {
                callbacks.callPostConstructCallback(o);
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
    }

    protected void destroy(Object o) {
        LifeCycleCallbackCollection callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
        if (callbacks != null) {
            try {
                callbacks.callPreDestroyCallback(o);
            }
            catch (Exception e) {
                LOG.warn("Destroying instance of " + o.getClass(), e);
            }
        }
    }
}

