/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.util.ThreadUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectId
implements Comparable<ObjectId> {
    static final boolean D = false;
    final int _time;
    final int _machine;
    final int _inc;
    boolean _new;
    private static int _nextInc = new Random().nextInt();
    private static final String _incLock = new String("ObjectId._incLock");
    private static int _gentime = ObjectId._flip((int)(System.currentTimeMillis() / 1000L));
    static final Thread _timeFixer;
    private static final int _genmachine;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() < 18) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectId massageToObjectId(Object o) {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectId) {
            return (ObjectId)o;
        }
        if (o instanceof String && ObjectId.isValid(s = o.toString())) {
            return new ObjectId(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId(Date time) {
        this._time = ObjectId._flip((int)(time.getTime() / 1000L));
        this._machine = _genmachine;
        String string = _incLock;
        synchronized (string) {
            this._inc = _nextInc++;
        }
        this._new = false;
    }

    public ObjectId(Date time, int inc) {
        this._time = ObjectId._flip((int)(time.getTime() / 1000L));
        this._machine = _genmachine;
        this._inc = inc;
        this._new = false;
    }

    public ObjectId(String s) {
        this(s, false);
    }

    public ObjectId(String s, boolean babble) {
        if (!ObjectId.isValid(s)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s + "]");
        }
        if (babble) {
            s = ObjectId.babbleToMongod(s);
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[b.length - (i + 1)] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        ByteBuffer bb = ByteBuffer.wrap(b);
        this._inc = bb.getInt();
        this._machine = bb.getInt();
        this._time = bb.getInt();
        this._new = false;
    }

    public ObjectId(byte[] b) {
        if (b.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ObjectId.reverse(b);
        ByteBuffer bb = ByteBuffer.wrap(b);
        this._inc = bb.getInt();
        this._machine = bb.getInt();
        this._time = bb.getInt();
    }

    ObjectId(int time, int machine, int inc) {
        this._time = time;
        this._machine = machine;
        this._inc = inc;
        this._new = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId() {
        this._time = _gentime;
        this._machine = _genmachine;
        String string = _incLock;
        synchronized (string) {
            this._inc = _nextInc++;
        }
        this._new = true;
    }

    public int hashCode() {
        return this._inc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        ObjectId other = ObjectId.massageToObjectId(o);
        if (other == null) {
            return false;
        }
        return this._time == other._time && this._machine == other._machine && this._inc == other._inc;
    }

    public String toStringBabble() {
        return ObjectId.babbleToMongod(this.toStringMongod());
    }

    public String toStringMongod() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._inc);
        bb.putInt(this._machine);
        bb.putInt(this._time);
        ObjectId.reverse(b);
        return b;
    }

    static void reverse(byte[] b) {
        for (int i = 0; i < b.length / 2; ++i) {
            byte t = b[i];
            b[i] = b[b.length - (i + 1)];
            b[b.length - (i + 1)] = t;
        }
    }

    static String _pos(String s, int p) {
        return s.substring(p * 2, p * 2 + 2);
    }

    public static String babbleToMongod(String b) {
        int i;
        if (!ObjectId.isValid(b)) {
            throw new IllegalArgumentException("invalid object id: " + b);
        }
        StringBuilder buf = new StringBuilder(24);
        for (i = 7; i >= 0; --i) {
            buf.append(ObjectId._pos(b, i));
        }
        for (i = 11; i >= 8; --i) {
            buf.append(ObjectId._pos(b, i));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    @Override
    public int compareTo(ObjectId id) {
        if (id == null) {
            return -1;
        }
        long xx = id.getTime() - this.getTime();
        if (xx > 0L) {
            return -1;
        }
        if (xx < 0L) {
            return 1;
        }
        int x = id._machine - this._machine;
        if (x != 0) {
            return -x;
        }
        x = id._inc - this._inc;
        if (x != 0) {
            return -x;
        }
        return 0;
    }

    public int getMachine() {
        return this._machine;
    }

    public long getTime() {
        long z = ObjectId._flip(this._time);
        return z * 1000L;
    }

    public int getInc() {
        return this._inc;
    }

    static int _flip(int x) {
        byte[] b = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(x);
        bb.flip();
        bb.order(ByteOrder.BIG_ENDIAN);
        return bb.getInt();
    }

    public static void main(String[] args) {
        int z = _nextInc;
        System.out.println(Integer.toHexString(z));
        System.out.println(Integer.toHexString(ObjectId._flip(z)));
        System.out.println(Integer.toHexString(ObjectId._flip(ObjectId._flip(z))));
    }

    static {
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
            }
            int machinePiece = sb.toString().hashCode() << 16;
            int processPiece = ManagementFactory.getRuntimeMXBean().getName().hashCode() & 0xFFFF;
            _genmachine = machinePiece | processPiece;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        _timeFixer = new Thread("ObjectId-TimeFixer"){

            public void run() {
                while (true) {
                    ThreadUtil.sleep(499L);
                    _gentime = ObjectId._flip((int)(System.currentTimeMillis() / 1000L));
                }
            }
        };
        _timeFixer.setDaemon(true);
        _timeFixer.start();
    }
}

