/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlSchema;
import liquibase.GlobalConfiguration;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.IntegrationDetails;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.MavenLogService;
import org.liquibase.maven.plugins.MavenResourceAccessor;
import org.liquibase.maven.plugins.MavenUtils;
import org.liquibase.maven.property.PropertyElement;

public abstract class AbstractLiquibaseMojo
extends AbstractMojo {
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    @PropertyElement
    protected String driver;
    @PropertyElement
    protected String url;
    protected WagonManager wagonManager;
    @PropertyElement
    protected String username;
    @PropertyElement
    protected String password;
    @PropertyElement
    protected boolean emptyPassword;
    @PropertyElement
    protected boolean outputDefaultSchema;
    @PropertyElement
    protected boolean outputDefaultCatalog;
    @PropertyElement
    protected String defaultCatalogName;
    @PropertyElement
    protected String defaultSchemaName;
    @PropertyElement
    protected String databaseClass;
    @PropertyElement
    protected String propertyProviderClass;
    @PropertyElement
    protected boolean promptOnNonLocalDatabase;
    @PropertyElement
    protected boolean includeArtifact;
    @PropertyElement
    protected boolean includeTestOutputDirectory;
    @PropertyElement
    protected boolean verbose;
    @PropertyElement
    protected String logging;
    @PropertyElement
    protected String propertyFile;
    @PropertyElement
    protected boolean propertyFileWillOverride;
    @PropertyElement
    protected boolean clearCheckSums;
    @PropertyElement
    protected Properties systemProperties;
    protected MavenProject project;
    @PropertyElement
    protected boolean skip;
    @PropertyElement
    protected String outputFileEncoding;
    @PropertyElement
    protected String changelogCatalogName;
    @PropertyElement
    protected String changelogSchemaName;
    @PropertyElement
    protected String databaseChangeLogTableName;
    @PropertyElement
    protected String databaseChangeLogLockTableName;
    @PropertyElement
    private String server;
    @PropertyElement
    private Liquibase liquibase;
    private Properties expressionVars;
    private Map expressionVariables;
    private File driverPropertiesFile;
    private boolean hasProLicense;
    @PropertyElement
    protected String liquibaseProLicenseKey;
    protected String commandName;

    protected boolean hasProLicense() {
        return this.hasProLicense;
    }

    protected Writer getOutputWriter(File outputFile) throws IOException {
        if (this.outputFileEncoding == null) {
            this.getLog().info((CharSequence)"Char encoding not set! The created file will be system dependent!");
            return new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
        }
        this.getLog().debug((CharSequence)("Writing output file with [" + this.outputFileEncoding + "] file encoding."));
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.outputFileEncoding));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Scope.child((Enum)Scope.Attr.logService, (Object)((Object)new MavenLogService(this.getLog())), () -> {
                AuthenticationInfo info;
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                if (this.server != null && (info = this.wagonManager.getAuthenticationInfo(this.server)) != null) {
                    this.username = info.getUserName();
                    this.password = info.getPassword();
                }
                this.processSystemProperties();
                if (!((Boolean)LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue()).booleanValue()) {
                    this.getLog().info((CharSequence)("Liquibase did not run because " + LiquibaseCommandLineConfiguration.SHOULD_RUN.getKey() + " was set to false"));
                    return;
                }
                if (this.skip) {
                    this.getLog().warn((CharSequence)"Liquibase skipped due to Maven configuration");
                    return;
                }
                ClassLoader mavenClassLoader = this.getClassLoaderIncludingProjectClasspath();
                HashMap<String, Object> scopeValues = new HashMap<String, Object>();
                scopeValues.put(Scope.Attr.resourceAccessor.name(), this.getResourceAccessor(mavenClassLoader));
                scopeValues.put(Scope.Attr.classLoader.name(), this.getClassLoaderIncludingProjectClasspath());
                IntegrationDetails integrationDetails = new IntegrationDetails();
                integrationDetails.setName("maven");
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                for (MojoDescriptor descriptor : pluginDescriptor.getMojos()) {
                    if (!descriptor.getImplementationClass().equals(((Object)((Object)this)).getClass())) continue;
                    for (Parameter param : descriptor.getParameters()) {
                        String name = param.getName();
                        if (name.equalsIgnoreCase("project") || name.equalsIgnoreCase("systemProperties")) continue;
                        Field field = this.getField(((Object)((Object)this)).getClass(), name);
                        if (field == null) {
                            this.getLog().debug((CharSequence)("Cannot read current maven value for. Will not send the value to hub " + name));
                            continue;
                        }
                        field.setAccessible(true);
                        Object value = field.get((Object)this);
                        if (value == null) continue;
                        try {
                            integrationDetails.setParameter("maven__" + param.getName().replaceAll("[${}]", ""), String.valueOf(value));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                scopeValues.put("integrationDetails", integrationDetails);
                Map pluginContext = this.getPluginContext();
                System.out.println(pluginContext.keySet());
                Scope.child(scopeValues, () -> {
                    this.configureFieldsAndValues();
                    this.hasProLicense = MavenUtils.checkProLicense(this.liquibaseProLicenseKey, this.commandName, this.getLog());
                    this.getLog().info((CharSequence)CommandLineUtils.getBanner());
                    this.displayMojoSettings();
                    this.checkRequiredParametersAreSpecified();
                    Database database = null;
                    try {
                        String dbPassword = this.emptyPassword || this.password == null ? "" : this.password;
                        String driverPropsFile = this.driverPropertiesFile == null ? null : this.driverPropertiesFile.getAbsolutePath();
                        database = CommandLineUtils.createDatabaseObject((ClassLoader)mavenClassLoader, (String)this.url, (String)this.username, (String)dbPassword, (String)this.driver, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (boolean)this.outputDefaultCatalog, (boolean)this.outputDefaultSchema, (String)this.databaseClass, (String)driverPropsFile, (String)this.propertyProviderClass, (String)this.changelogCatalogName, (String)this.changelogSchemaName, (String)this.databaseChangeLogTableName, (String)this.databaseChangeLogLockTableName);
                        this.liquibase = this.createLiquibase(database);
                        this.configureChangeLogProperties();
                        this.getLog().debug((CharSequence)("expressionVars = " + String.valueOf(this.expressionVars)));
                        if (this.expressionVars != null) {
                            for (Map.Entry<Object, Object> entry : this.expressionVars.entrySet()) {
                                this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                            }
                        }
                        this.getLog().debug((CharSequence)("expressionVariables = " + String.valueOf(this.expressionVariables)));
                        if (this.expressionVariables != null) {
                            for (Map.Entry<Object, Object> entry : this.expressionVariables.entrySet()) {
                                if (entry.getValue() == null) continue;
                                this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                            }
                        }
                        if (this.clearCheckSums) {
                            this.getLog().info((CharSequence)"Clearing the Liquibase checksums on the database");
                            this.liquibase.clearCheckSums();
                        }
                        this.getLog().info((CharSequence)("Executing on Database: " + this.url));
                        if (this.isPromptOnNonLocalDatabase()) {
                            this.getLog().info((CharSequence)"NOTE: The promptOnLocalDatabase functionality has been removed");
                        }
                        this.setupBindInfoPackage();
                        this.performLiquibaseTask(this.liquibase);
                    }
                    catch (LiquibaseException e) {
                        this.cleanup(database);
                        throw new MojoExecutionException("\nError setting up or running Liquibase:\n" + e.getMessage(), (Exception)((Object)e));
                    }
                    this.cleanup(database);
                    this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                    this.getLog().info((CharSequence)"");
                });
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected Field getField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (clazz.equals(Object.class)) {
                return null;
            }
            return this.getField(clazz.getSuperclass(), name);
        }
    }

    protected Liquibase getLiquibase() {
        return this.liquibase;
    }

    protected void setupBindInfoPackage() {
        String nsuri = "http://www.hibernate.org/xsd/orm/hbm";
        String packageInfoClassName = "org.hibernate.boot.jaxb.hbm.spi.package-info";
        try {
            Class<?> packageInfoClass = Class.forName(packageInfoClassName);
            XmlSchema xmlSchema = packageInfoClass.getAnnotation(XmlSchema.class);
            if (xmlSchema == null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] is missing the [{1}] annotation. Processing bindings will probably fail.", packageInfoClassName, XmlSchema.class.getName()));
            } else {
                String namespace = xmlSchema.namespace();
                if (nsuri.equals(namespace)) {
                    this.getLog().warn((CharSequence)MessageFormat.format("Namespace of the [{0}] annotation does not match [{1}]. Processing bindings will probably fail.", XmlSchema.class.getName(), nsuri));
                }
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().debug((CharSequence)MessageFormat.format("Class [{0}] could not be found. Processing hibernate bindings will probably fail if applicable.", packageInfoClassName), (Throwable)cnfex);
        }
    }

    protected abstract void performLiquibaseTask(Liquibase var1) throws LiquibaseException;

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }

    private void displayMojoSettings() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"Settings\n----------------------------");
            this.printSettings("    ");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        return new Liquibase("", Scope.getCurrentScope().getResourceAccessor(), db);
    }

    public void configureFieldsAndValues() throws MojoExecutionException, MojoFailureException {
        if (this.propertyFile != null) {
            this.getLog().info((CharSequence)"Parsing Liquibase Properties File");
            this.getLog().info((CharSequence)("  File: " + this.propertyFile));
            try (InputStream is = AbstractLiquibaseMojo.handlePropertyFileInputStream(this.propertyFile);){
                if (is == null) {
                    throw new MojoExecutionException(FileUtil.getFileNotFoundMessage((String)this.propertyFile));
                }
                this.parsePropertiesFile(is);
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
    }

    protected void configureChangeLogProperties() throws MojoFailureException, MojoExecutionException {
        if (this.propertyFile != null) {
            this.getLog().info((CharSequence)("Parsing Liquibase Properties File " + this.propertyFile + " for changeLog parameters"));
            try (InputStream propertiesInputStream = AbstractLiquibaseMojo.handlePropertyFileInputStream(this.propertyFile);){
                Properties props = AbstractLiquibaseMojo.loadProperties(propertiesInputStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("parameter.")) continue;
                    this.getLog().debug((CharSequence)("Setting changeLog parameter " + key));
                    this.liquibase.setChangeLogParameter(key.replaceFirst("^parameter.", ""), entry.getValue());
                }
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
    }

    private static InputStream handlePropertyFileInputStream(String propertyFile) throws MojoFailureException {
        InputStream is;
        try {
            is = Scope.getCurrentScope().getResourceAccessor().openStream(null, propertyFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to resolve the properties file.", (Throwable)e);
        }
        return is;
    }

    protected ClassLoader getMavenArtifactClassLoader() throws MojoExecutionException {
        try {
            return MavenUtils.getArtifactClassloader(this.project, this.includeArtifact, this.includeTestOutputDirectory, ((Object)((Object)this)).getClass(), this.getLog(), this.verbose);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create artifact classloader", (Exception)e);
        }
    }

    protected ClassLoader getClassLoaderIncludingProjectClasspath() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, this.getMavenArtifactClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create project classloader", e);
        }
    }

    protected ResourceAccessor getResourceAccessor(ClassLoader cl) {
        MavenResourceAccessor mFO = new MavenResourceAccessor(cl);
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor(new File[]{this.project.getBasedir()});
        return new CompositeResourceAccessor(new ResourceAccessor[]{mFO, fsFO});
    }

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        if (this.url == null) {
            throw new MojoFailureException("The database URL has not been specified either as a parameter or in a properties file.");
        }
        if (this.password != null && this.emptyPassword) {
            throw new MojoFailureException("A password cannot be present and the empty password property both be specified.");
        }
    }

    protected void printSettings(String indent) {
        if (indent == null) {
            indent = "";
        }
        this.getLog().info((CharSequence)(indent + "driver: " + this.driver));
        this.getLog().info((CharSequence)(indent + "url: " + this.url));
        this.getLog().info((CharSequence)(indent + "username: *****"));
        this.getLog().info((CharSequence)(indent + "password: *****"));
        this.getLog().info((CharSequence)(indent + "use empty password: " + this.emptyPassword));
        this.getLog().info((CharSequence)(indent + "properties file: " + this.propertyFile));
        this.getLog().info((CharSequence)(indent + "properties file will override? " + this.propertyFileWillOverride));
        this.getLog().info((CharSequence)(indent + "clear checksums? " + this.clearCheckSums));
    }

    protected void cleanup(Database db) {
        if (db != null) {
            try {
                db.rollback();
                db.close();
            }
            catch (DatabaseException e) {
                this.getLog().error((CharSequence)"Failed to close open connection to database.", (Throwable)e);
            }
        }
    }

    private static Properties loadProperties(InputStream propertiesInputStream) throws MojoExecutionException {
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
            return props;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = AbstractLiquibaseMojo.loadProperties(propertiesInputStream);
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = MavenUtils.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else if (field.getType().equals(File.class)) {
            field.set((Object)this, new File(value));
        } else {
            field.set((Object)this, value);
        }
    }

    private void processSystemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        for (String string : this.systemProperties.keySet()) {
            String value = this.systemProperties.getProperty(string);
            System.setProperty(string, value);
        }
    }
}

