/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.file.Paths;
import java.util.Arrays;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.util.Environment;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.FilesKeystoreVaultProvider;
import org.keycloak.vault.Scenario;
import org.keycloak.vault.SecretContains;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;

public class KeystoreVaultProviderTest {
    @Before
    public void before() {
        Assume.assumeFalse((String)"Java is in FIPS mode. Skipping the test.", (boolean)Environment.isJavaInFipsMode());
    }

    @Test
    public void shouldObtainSecret() {
        FilesKeystoreVaultProvider provider = new FilesKeystoreVaultProvider(Paths.get(Scenario.EXISTING.getAbsolutePathAsString() + "/myks", new String[0]), "keystorepassword", "PKCS12", "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret1 = provider.obtainSecret("alias");
        Assert.assertNotNull((Object)secret1);
        Assert.assertNotNull(secret1.get().get());
        MatcherAssert.assertThat((Object)secret1, SecretContains.secretContains("topsecret"));
    }

    @Test
    public void shouldObtainSecretFromDifferentKeystoreType() {
        FilesKeystoreVaultProvider provider = new FilesKeystoreVaultProvider(Paths.get(Scenario.EXISTING.getAbsolutePathAsString() + "/myks.jceks", new String[0]), "keystorepassword", "JCEKS", "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret1 = provider.obtainSecret("alias");
        Assert.assertNotNull((Object)secret1);
        Assert.assertNotNull(secret1.get().get());
        MatcherAssert.assertThat((Object)secret1, SecretContains.secretContains("topsecret"));
    }

    @Test
    public void shouldFailBecauseOfTypeMismatch() {
        FilesKeystoreVaultProvider provider = new FilesKeystoreVaultProvider(Paths.get(Scenario.EXISTING.getAbsolutePathAsString() + "/myks", new String[0]), "keystorepassword", "JCEKS", "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        Assert.assertThrows((String)"java.io.IOException: Invalid keystore format", RuntimeException.class, () -> KeystoreVaultProviderTest.lambda$shouldFailBecauseOfTypeMismatch$0((VaultProvider)provider));
    }

    private static /* synthetic */ void lambda$shouldFailBecauseOfTypeMismatch$0(VaultProvider provider) throws Throwable {
        provider.obtainSecret("alias");
    }
}

