/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jax_ws_commons.jaxws.AbstractJaxwsMojo;

abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    @Parameter(defaultValue="false")
    protected boolean genWsdl;
    @Parameter
    private String sei;
    @Parameter
    private String protocol;
    @Parameter(property="plugin.artifacts", readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter
    private String servicename;
    @Parameter
    private String portname;
    @Parameter(defaultValue="false")
    private boolean inlineSchemas;
    @Parameter(defaultValue="false")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xdonotoverwrite;

    AbstractWsGenMojo() {
    }

    protected abstract File getResourceDestDir();

    protected abstract File getClassesDir();

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> seis = new HashSet<String>();
        if (this.sei != null) {
            seis.add(this.sei);
        } else {
            seis.addAll(this.getSEIs(this.getClassesDir()));
        }
        if (seis.isEmpty()) {
            throw new MojoFailureException("No @javax.jws.WebService found.");
        }
        try {
            for (String aSei : seis) {
                ArrayList<String> args = this.getWsGenArgs(aSei);
                this.exec(args);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Failed to execute wsgen", e);
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsgenTool";
    }

    @Override
    protected String getExtraClasspath() {
        return this.getClassesDir().getAbsolutePath();
    }

    private ArrayList<String> getWsGenArgs(String aSei) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCommonArgs());
        if (this.genWsdl) {
            File resourceDir;
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            if (this.inlineSchemas) {
                this.maybeUnsupportedOption("-inlineSchemas", null, args);
            }
            if (this.servicename != null) {
                args.add("-servicename");
                args.add(this.servicename);
            }
            if (this.portname != null) {
                args.add("-portname");
                args.add(this.portname);
            }
            if (!(resourceDir = this.getResourceDestDir()).mkdirs() && !resourceDir.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + resourceDir.getAbsolutePath()));
            }
            args.add("-r");
            args.add(resourceDir.getAbsolutePath());
            Resource r = new Resource();
            r.setDirectory(this.getRelativePath(this.project.getBasedir(), this.getResourceDestDir()));
            this.project.addResource(r);
        }
        if (this.xdonotoverwrite) {
            args.add("-Xdonotoverwrite");
        }
        args.add(aSei);
        this.getLog().debug((CharSequence)("jaxws:wsgen args: " + args));
        return args;
    }

    private String getRelativePath(File root, File f) {
        return root.toURI().relativize(f.toURI()).getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getSEIs(File directory) throws MojoExecutionException {
        HashSet<String> seis = new HashSet<String>();
        if (!directory.exists() || directory.isFile()) {
            return seis;
        }
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(new URL[]{directory.toURI().toURL()});
            for (String s : FileUtils.getFileAndDirectoryNames((File)directory, (String)"**/*.class", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false)) {
                try {
                    String clsName = s.replace(File.separator, ".");
                    Class<?> c = cl.loadClass(clsName.substring(0, clsName.length() - 6));
                    WebService ann = c.getAnnotation(WebService.class);
                    if (c.isInterface() || ann == null) continue;
                    seis.add(c.getName());
                }
                catch (ClassNotFoundException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                    return seis;
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            if (cl != null && cl instanceof Closeable) {
                try {
                    ((Closeable)cl).close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

