/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ@\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018H\u0002JJ\u0010\u0019\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J6\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010%\u001a\u00020\u001dH\u0002J<\u0010&\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u00020\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0018\u0010,\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u001dH\u0002J(\u0010.\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020(H\u0002J\u001e\u00104\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018J.\u00105\u001a\n 6*\u0004\u0018\u00010\u001d0\u001d2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u00107\u001a\u00020\u001d2\b\u00108\u001a\u0004\u0018\u00010\u001dH\u0002J:\u00109\u001a\u0004\u0018\u00010\u001d\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\u0006\u0010%\u001a\u00020\u001dH\u0002J:\u0010:\u001a\u0004\u0018\u00010\u001d\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010<\u001a\u00020=\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018J*\u0010>\u001a\u0004\u0018\u00010\u001d2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030?H\u0002J\f\u0010@\u001a\u00020(*\u00020\u0016H\u0002J \u0010A\u001a\u0004\u0018\u00010\u001d*\u00020\u00162\u0006\u0010B\u001a\u00020C2\b\u0010-\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "coroutineInferenceSupport", "Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "addConstraintForCallableReference", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "callableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "addConstraintForFunctionLiteralArgument", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "argumentOwnerReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "addConstraintForNestedCall", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constraintPosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "builder", "effectiveExpectedType", "addConstraintForValueArgument", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "addExpectedTypeForExplicitCast", "addValidityConstraintsForConstituentTypes", "type", "addValidityConstraintsForTypeArgument", "substitutedArgument", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "boundsSubstitutor", "completeTypeInferenceDependentOnFunctionArgumentsForCall", "estimateLiteralReturnType", "kotlin.jvm.PlatformType", "literalExpectedType", "ownerReturnType", "getExpectedTypeForCallableReference", "getResolvedTypeForCallableReference", "expectedType", "inferTypeArguments", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "updateResultTypeForSmartCasts", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "compositeSubstitutor", "typeInSystem", "call", "Lorg/jetbrains/kotlin/psi/Call;", "frontend"})
public final class GenericCandidateResolver {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CoroutineInferenceSupport coroutineInferenceSupport;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public GenericCandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CoroutineInferenceSupport coroutineInferenceSupport, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)coroutineInferenceSupport, (String)"coroutineInferenceSupport");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.argumentTypeResolver = argumentTypeResolver;
        this.coroutineInferenceSupport = coroutineInferenceSupport;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(@NotNull CallCandidateResolutionContext<D> context2) {
        Object resolvedValueArgument;
        Object object;
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        MutableResolvedCall mutableResolvedCall = context2.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, (String)"context.candidateCall");
        MutableResolvedCall candidateCall = mutableResolvedCall;
        Object d = candidateCall.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, (String)"candidateCall.candidateDescriptor");
        Object candidate2 = d;
        ConstraintSystemBuilderImpl builder2 = new ConstraintSystemBuilderImpl(null, 1, null);
        ConstraintSystem.Builder builder3 = builder2;
        Object object2 = candidateCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"candidateCall.call");
        CallHandle callHandle = TypeVariableKt.toHandle((Call)object2);
        object2 = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"candidate.typeParameters");
        ConstraintSystem.Builder.DefaultImpls.registerTypeVariables$default(builder3, callHandle, (Collection)object2, false, 4, null);
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"candidate.typeParameters");
        Collection collection = (Collection)((Object)iterator2);
        iterator2 = TypeUtils.DONT_CARE;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"DONT_CARE");
        TypeSubstitutor substituteDontCare = GenericCandidateResolverKt.makeConstantSubstitutor(collection, (KotlinType)((Object)iterator2));
        Object object3 = candidateCall.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object3, (String)"candidateCall.valueArguments");
        boolean bl = false;
        iterator2 = object3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object4 = object3 = iterator2.next();
            boolean bl2 = false;
            ValueParameterDescriptor candidateParameter = (ValueParameterDescriptor)object4.getKey();
            object = object3;
            boolean bl3 = false;
            resolvedValueArgument = (ResolvedValueArgument)object.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidate2.getValueParameters().get(candidateParameter.getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"valueArgument");
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, builder2, context2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            }
        }
        if (candidate2 instanceof TypeAliasConstructorDescriptor) {
            object3 = this.compositeSubstitutor(builder2).safeSubstitute(((TypeAliasConstructorDescriptor)candidate2).getReturnType(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"builder.compositeSubstit\u2026Type, Variance.INVARIANT)");
            Object substitutedReturnType = object3;
            this.addValidityConstraintsForConstituentTypes(builder2, (KotlinType)substitutedReturnType);
        }
        ReceiverValue receiverArgument = candidateCall.getExtensionReceiver();
        ReceiverParameterDescriptor receiverParameter = candidate2.getExtensionReceiverParameter();
        if (receiverArgument != null && receiverParameter != null) {
            Object receiverType;
            resolvedValueArgument = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedValueArgument, (String)"receiverArgument.type");
            Object receiverArgumentType = resolvedValueArgument;
            object = context2.candidateCall.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.candidateCall.call");
            Object object5 = receiverType = CallUtilKt.isSafeCall((Call)object) ? TypeUtils.makeNotNullable((KotlinType)receiverArgumentType) : receiverArgumentType;
            if (receiverArgument instanceof ExpressionReceiver) {
                receiverType = this.updateResultTypeForSmartCasts((KotlinType)receiverType, ((ExpressionReceiver)receiverArgument).getExpression(), (ResolutionContext)context2);
            }
            builder2.addSubtypeConstraint((KotlinType)receiverType, this.compositeSubstitutor(builder2).substitute(receiverParameter.getType(), Variance.INVARIANT), ConstraintPositionKind.RECEIVER_POSITION.position());
        }
        ConstraintSystem constraintSystem = builder2.build();
        candidateCall.setConstraintSystem(constraintSystem);
        boolean hasContradiction = constraintSystem.getStatus().hasContradiction();
        if (!hasContradiction) {
            this.addExpectedTypeForExplicitCast(context2, builder2);
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        return ResolutionStatus.OTHER_ERROR;
    }

    private final KotlinType typeInSystem(ConstraintSystem.Builder $this$typeInSystem, Call call2, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 == null) {
            kotlinType = null;
        } else {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            TypeSubstitutor typeSubstitutor2 = $this$typeInSystem.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(call2));
            kotlinType = typeSubstitutor2 == null ? null : typeSubstitutor2.substitute(it, Variance.INVARIANT);
        }
        return kotlinType;
    }

    private final void addExpectedTypeForExplicitCast(CallCandidateResolutionContext<?> context2, ConstraintSystem.Builder builder2) {
        Object expectedType2;
        FunctionDescriptor functionDescriptor;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExpectedTypeFromCast)) {
            return;
        }
        if (context2.candidateCall instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object $this$safeAs$iv = context2.candidateCall.getCandidateDescriptor();
        boolean $i$f$safeAs22 = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof FunctionDescriptor)) {
            object = null;
        }
        if ((functionDescriptor = (FunctionDescriptor)object) == null) {
            return;
        }
        FunctionDescriptor candidateDescriptor = functionDescriptor;
        Object $i$f$safeAs22 = context2.call.getCalleeExpression();
        KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS = $this$safeAs$iv = $i$f$safeAs22 == null ? null : KtPsiUtilKt.getBinaryWithTypeParent((KtExpression)$i$f$safeAs22);
        if ($this$safeAs$iv == null) {
            return;
        }
        Object binaryParent = $this$safeAs$iv;
        Object object2 = ((KtBinaryExpressionWithTypeRHS)binaryParent).getOperationReference().getReferencedNameElementType();
        boolean bl = false;
        boolean bl2 = false;
        IElementType it = object2;
        boolean bl3 = false;
        Object object3 = $i$f$safeAs22 = Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_KEYWORD) || Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_SAFE) ? object2 : null;
        if ($i$f$safeAs22 == null) {
            return;
        }
        Object operationType = $i$f$safeAs22;
        Object object4 = ((KtBinaryExpressionWithTypeRHS)binaryParent).getRight();
        if (object4 == null) {
            return;
        }
        KotlinType kotlinType = (KotlinType)context2.trace.get(BindingContext.TYPE, object4);
        if (kotlinType == null) {
            return;
        }
        Object leftType = object2 = kotlinType;
        Object object5 = expectedType2 = Intrinsics.areEqual((Object)operationType, (Object)KtTokens.AS_SAFE) ? TypeUtilsKt.makeNullable((KotlinType)leftType) : leftType;
        if (context2.candidateCall.getCall().getTypeArgumentList() != null || !KtDescriptorUtilKt.isFunctionForExpectTypeFromCastFeature(candidateDescriptor)) {
            return;
        }
        Object object6 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"context.call");
        Call call2 = object6;
        object6 = candidateDescriptor.getReturnType();
        if (object6 == null) {
            return;
        }
        object4 = this.typeInSystem(builder2, call2, (KotlinType)object6);
        if (object4 == null) {
            return;
        }
        Object typeInSystem = object4;
        context2.trace.record(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, binaryParent);
        builder2.addSubtypeConstraint((KotlinType)typeInSystem, (KotlinType)expectedType2, ConstraintPositionKind.SPECIAL.position());
    }

    /*
     * WARNING - void declaration
     */
    private final void addValidityConstraintsForConstituentTypes(ConstraintSystem.Builder builder2, KotlinType type2) {
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(type)");
        TypeSubstitutor boundsSubstitutor = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = type2.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeProjection;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv;
            int i = n;
            boolean bl2 = false;
            if (typeProjection.isStarProjection()) continue;
            TypeParameterDescriptor typeParameter = typeConstructor2.getParameters().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter, (String)"typeParameter");
            this.addValidityConstraintsForTypeArgument(builder2, (TypeProjection)typeProjection, typeParameter, boundsSubstitutor);
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeProjection.type");
            this.addValidityConstraintsForConstituentTypes(builder2, kotlinType);
        }
    }

    private final void addValidityConstraintsForTypeArgument(ConstraintSystem.Builder builder2, TypeProjection substitutedArgument, TypeParameterDescriptor typeParameter, TypeSubstitutor boundsSubstitutor) {
        KotlinType kotlinType = substitutedArgument.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"substitutedArgument.type");
        KotlinType substitutedType = kotlinType;
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            KotlinType kotlinType2 = boundsSubstitutor.safeSubstitute(upperBound, Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"boundsSubstitutor.safeSu\u2026ound, Variance.INVARIANT)");
            SimpleType substitutedUpperBound = FlexibleTypesKt.upperIfFlexible(kotlinType2);
            ValidityConstraintForConstituentType constraintPosition = new ValidityConstraintForConstituentType(substitutedType, typeParameter, substitutedUpperBound);
            if (KotlinBuiltIns.isNullableAny(substitutedUpperBound)) continue;
            builder2.addSubtypeConstraint(substitutedType, substitutedUpperBound, constraintPosition);
        }
    }

    private final TypeSubstitutor compositeSubstitutor(ConstraintSystem.Builder $this$compositeSubstitutor) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeSubstitution($this$compositeSubstitutor){
            final /* synthetic */ ConstraintSystem.Builder $this_compositeSubstitutor;
            {
                this.$this_compositeSubstitutor = $receiver;
            }

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (TypeProjection)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.reversed((Iterable)this.$this_compositeSubstitutor.getTypeVariableSubstitutors().values())), (Function1)((Function1)new Function1<TypeSubstitutor, TypeProjection>(key){
                    final /* synthetic */ KotlinType $key;
                    {
                        this.$key = $key;
                        super(1);
                    }

                    @Nullable
                    public final TypeProjection invoke(@NotNull TypeSubstitutor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.getSubstitution().get(this.$key);
                    }
                })));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"ConstraintSystem.Builder\u2026\n            }\n        })");
        return typeSubstitutor2;
    }

    private final void addConstraintForValueArgument(ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, TypeSubstitutor substitutor2, ConstraintSystem.Builder builder2, CallCandidateResolutionContext<?> context2, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        KotlinType expectedType2 = substitutor2.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfo = context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.candidateCall.da\u2026ts.getInfo(valueArgument)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Object Context2 = ((CallCandidateResolutionContext)context2.replaceExpectedType(expectedType2)).replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedT\u2026(dataFlowInfoForArgument)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        KotlinType kotlinType = expectedType2;
        KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies, kotlinType == null ? false : FunctionTypesKt.isSuspendFunctionType(kotlinType));
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"argumentTypeResolver.get\u2026ionType == true\n        )");
        KotlinTypeInfo typeInfoForCall = kotlinTypeInfo;
        context2.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        ConstraintPosition constraintPosition = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (this.addConstraintForNestedCall(argumentExpression, constraintPosition, builder2, newContext, effectiveExpectedType)) {
            return;
        }
        KotlinType kotlinType2 = typeInfoForCall.getType();
        Object Context3 = context2.replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context3, (String)"context.replaceDataFlowI\u2026(dataFlowInfoForArgument)");
        KotlinType type2 = this.updateResultTypeForSmartCasts(kotlinType2, argumentExpression, (ResolutionContext<?>)Context3);
        if (argumentExpression instanceof KtCallableReferenceExpression && type2 == null) {
            return;
        }
        builder2.addSubtypeConstraint(type2, this.compositeSubstitutor(builder2).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addConstraintForNestedCall(KtExpression argumentExpression, ConstraintPosition constraintPosition, ConstraintSystem.Builder builder2, CallCandidateResolutionContext<?> context2, KotlinType effectiveExpectedType) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        KotlinType returnType2;
        Object candidateDescriptor;
        ResolvedCall nestedCall;
        block9: {
            KotlinType kotlinType;
            ConstraintSystem constraintSystem;
            OverloadResolutionResultsImpl<?> resolutionResults;
            ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(argumentExpression, (ResolutionContext)context2);
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = resolutionResults = cachedData == null ? null : cachedData.getResolutionResults();
            if (resolutionResults == null || !resolutionResults.isSingleResult()) {
                return false;
            }
            ResolvedCall resolvedCall2 = resolutionResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"resolutionResults.resultingCall");
            nestedCall = resolvedCall2;
            if (nestedCall.isCompleted()) {
                return false;
            }
            ConstraintSystem constraintSystem2 = nestedCall.getConstraintSystem();
            if (constraintSystem2 == null) {
                return false;
            }
            ConstraintSystem nestedConstraintSystem = constraintSystem = constraintSystem2;
            candidateDescriptor = nestedCall.getCandidateDescriptor();
            KotlinType kotlinType2 = candidateDescriptor.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            returnType2 = kotlinType = kotlinType2;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(nestedConstraintSystem, returnType2);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    Collection<TypeBounds.Bound> collection = nestedConstraintSystem.getTypeBounds(it).getBounds();
                    boolean bl3 = false;
                    boolean bl4 = !collection.isEmpty();
                    if (!bl4) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidateDescriptor);
        List<TypeParameterDescriptor> list2 = candidateDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"candidateDescriptor.typeParameters");
        Iterable iterable = list2;
        list2 = candidateWithFreshVariables.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"candidateWithFreshVariables.typeParameters");
        Map conversion = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable, (Iterable)list2));
        Object $this$mapNotNull$iv = ConstraintSystemUtilsKt.getNestedTypeParameters(returnType2);
        boolean $i$f$mapNotNull = false;
        Iterable bl2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl6 = false;
            if ((TypeParameterDescriptor)conversion.get(it) == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            TypeParameterDescriptor it$iv$iv = typeParameterDescriptor;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List freshVariables = (List)destination$iv$iv;
        $this$mapNotNull$iv = nestedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapNotNull$iv, (String)"nestedCall.call");
        builder2.registerTypeVariables(TypeVariableKt.toHandle((Call)$this$mapNotNull$iv), freshVariables, true);
        KotlinType argumentExpressionType = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(nestedCall, candidateWithFreshVariables.getReturnType(), (CallResolutionContext)context2);
        builder2.addSubtypeConstraint(argumentExpressionType, this.compositeSubstitutor(builder2).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
        return true;
    }

    private final KotlinType updateResultTypeForSmartCasts(KotlinType type2, KtExpression argumentExpression, ResolutionContext<?> context2) {
        KtExpression deparenthesizedArgument = KtPsiUtil.getLastElementDeparenthesized(argumentExpression, context2.statementFilter);
        if (deparenthesizedArgument == null || type2 == null) {
            return type2;
        }
        DataFlowValue dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(deparenthesizedArgument, type2, context2);
        if (!dataFlowValue2.isStable()) {
            return type2;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"context.languageVersionSettings");
        Set<KotlinType> possibleTypes = dataFlowInfo.getCollectedTypes(dataFlowValue2, languageVersionSettings);
        if (possibleTypes.isEmpty()) {
            return type2;
        }
        return TypeIntersector.intersectTypes(SetsKt.plus(possibleTypes, (Object)type2));
    }

    public final <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionArgumentsForCall(@NotNull CallCandidateResolutionContext<D> context2) {
        Iterator<ValueArgument> iterator2;
        ConstraintSystem.Builder builder2;
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        MutableResolvedCall mutableResolvedCall = context2.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, (String)"context.candidateCall");
        MutableResolvedCall resolvedCall2 = mutableResolvedCall;
        Object object = resolvedCall2.getConstraintSystem();
        ConstraintSystem.Builder builder3 = builder2 = object == null ? null : ConstraintSystem.DefaultImpls.toBuilder$default((ConstraintSystem)object, null, 1, null);
        if (builder2 == null) {
            return;
        }
        ConstraintSystem.Builder constraintSystem = builder2;
        CallCandidateResolutionContext newContext = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? CallCandidateResolutionContext.create(resolvedCall2, context2, context2.trace, context2.tracing, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getCall(), context2.candidateResolveMode) : context2;
        Iterator<ValueArgument> iterator3 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"resolvedCall.valueArguments");
        boolean bl = false;
        object = iterator3.entrySet().iterator();
        while (object.hasNext()) {
            iterator2 = iterator3 = (Map.Entry)object.next();
            boolean bl2 = false;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)iterator2.getKey();
            Iterator<ValueArgument> iterator4 = iterator3;
            boolean bl3 = false;
            ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)iterator4.getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                CallCandidateResolutionContext callCandidateResolutionContext;
                boolean bl4;
                KtExpression ktExpression;
                KtExpression ktExpression2 = valueArgument.getArgumentExpression();
                if (ktExpression2 == null) continue;
                KtExpression ktExpression3 = ktExpression2;
                boolean bl5 = false;
                boolean bl6 = false;
                KtExpression argumentExpression = ktExpression3;
                boolean bl7 = false;
                KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(argumentExpression, newContext);
                if (ktFunction != null) {
                    ktExpression = ktFunction;
                    boolean bl8 = false;
                    bl4 = false;
                    KtFunction functionLiteral = ktExpression;
                    boolean bl9 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"valueArgument");
                    Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
                    Intrinsics.checkNotNullExpressionValue((Object)newContext, (String)"newContext");
                    this.addConstraintForFunctionLiteralArgument(functionLiteral, valueArgument, valueParameterDescriptor, constraintSystem, newContext, resolvedCall2.getCandidateDescriptor().getReturnType());
                }
                if (GenericCandidateResolverKt.getSPECIAL_FUNCTION_NAMES().contains(resolvedCall2.getCandidateDescriptor().getName())) {
                    callCandidateResolutionContext = newContext;
                } else {
                    TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(newContext.trace, "Trace to complete argument for call that might be not resulting call");
                    Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(\n                \u2026                        )");
                    TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
                    callCandidateResolutionContext = (CallCandidateResolutionContext)newContext.replaceBindingTrace(temporaryBindingTrace2);
                }
                CallCandidateResolutionContext temporaryContextForCall = callCandidateResolutionContext;
                ktExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(argumentExpression, newContext);
                if (ktExpression == null) continue;
                KtExpression ktExpression4 = ktExpression;
                bl4 = false;
                boolean bl10 = false;
                KtExpression callableReference = ktExpression4;
                boolean bl11 = false;
                Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"valueArgument");
                Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameterDescriptor");
                Intrinsics.checkNotNullExpressionValue((Object)temporaryContextForCall, (String)"temporaryContextForCall");
                this.addConstraintForCallableReference((KtCallableReferenceExpression)callableReference, valueArgument, valueParameterDescriptor, constraintSystem, temporaryContextForCall);
            }
        }
        ConstraintSystem resultingSystem = constraintSystem.build();
        resolvedCall2.setConstraintSystem(resultingSystem);
        boolean isNewInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        iterator2 = isNewInferenceEnabled ? resultingSystem.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : resultingSystem.getResultingSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"if (isNewInferenceEnable\u2026stem.resultingSubstitutor");
        Iterator<ValueArgument> resultingSubstitutor2 = iterator2;
        resolvedCall2.setSubstitutor((TypeSubstitutor)((Object)resultingSubstitutor2));
    }

    private final KotlinType estimateLiteralReturnType(CallCandidateResolutionContext<?> context2, KotlinType literalExpectedType, KotlinType ownerReturnType) {
        return !TypeUtils.noExpectedType(context2.expectedType) && ownerReturnType != null && TypeUtils.isTypeParameter(ownerReturnType) && FunctionTypesKt.isFunctionTypeOrSubtype(literalExpectedType) && Intrinsics.areEqual((Object)CallResolverUtilKt.getReturnTypeForCallable(literalExpectedType), (Object)ownerReturnType) ? context2.expectedType : (KotlinType)TypeUtils.DONT_CARE;
    }

    private final <D extends CallableDescriptor> void addConstraintForFunctionLiteralArgument(KtFunction functionLiteral, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2, KotlinType argumentOwnerReturnType) {
        Object errorInterceptingTrace;
        TypeSubstitutor currentSubstitutor2;
        TypeSubstitution typeSubstitution;
        DelegatedTypeSubstitution newSubstitution2;
        KotlinType expectedType2;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        if (CoroutineInferenceUtilKt.isCoroutineCallWithAdditionalInference(valueParameterDescriptor, valueArgument, this.languageVersionSettings)) {
            this.coroutineInferenceSupport.analyzeCoroutine(functionLiteral, valueArgument, constraintSystem, context2, effectiveExpectedType);
        }
        if ((expectedType2 = (newSubstitution2 = new DelegatedTypeSubstitution(typeSubstitution = (currentSubstitutor2 = constraintSystem.build().getCurrentSubstitutor()).getSubstitution()){
            {
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        }).buildSubstitutor().substitute(effectiveExpectedType, Variance.IN_VARIANCE)) == null || TypeUtils.isDontCarePlaceholder(expectedType2)) {
            KotlinType kotlinType = expectedType2;
            expectedType2 = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteral, context2.scope, context2.trace, false, kotlinType == null ? false : FunctionTypesKt.isSuspendFunctionType(kotlinType));
        }
        if (expectedType2 == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType2) || CallResolverUtilKt.hasUnknownFunctionParameter(expectedType2)) {
            return;
        }
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context2.candidateCall.getDataFlowInfoForArguments();
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataFlowInfoForArguments, (String)"context.candidateCall.dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = mutableDataFlowInfoForArguments;
        DataFlowInfo dataFlowInfo = dataFlowInfoForArguments.getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfoForArguments.getInfo(valueArgument)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"context.call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        KotlinType effectiveExpectedTypeInSystem = typeSubstitutor2 == null ? null : typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT);
        boolean hasExpectedReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType2);
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (hasExpectedReturnType) {
            KtExpression ktExpression2;
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context2, "trace to resolve function literal with expected return type", argumentExpression);
            KtExpression ktExpression3 = KtPsiUtil.getExpressionOrLastStatementInBlock(functionLiteral.getBodyExpression());
            if (ktExpression3 == null) {
                return;
            }
            KtExpression statementExpression = ktExpression2 = ktExpression3;
            boolean[] mismatch = new boolean[1];
            errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceBindingTrace((BindingTrace)errorInterceptingTrace)).replaceExpectedType(expectedType2)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceBindingTr\u2026xtDependency(INDEPENDENT)");
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
            KotlinType type2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType2)).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type2, effectiveExpectedTypeInSystem, position);
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        KotlinType estimatedReturnType = this.estimateLiteralReturnType(context2, effectiveExpectedType, argumentOwnerReturnType);
        Intrinsics.checkNotNullExpressionValue((Object)estimatedReturnType, (String)"estimatedReturnType");
        KotlinType expectedTypeWithEstimatedReturnType = CallResolverUtilKt.replaceReturnTypeForCallable(expectedType2, estimatedReturnType);
        errorInterceptingTrace = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedTypeWithEstimatedReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(errorInterceptingTrace, (String)"context.replaceExpectedT\u2026xtDependency(INDEPENDENT)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)errorInterceptingTrace;
        KotlinType type3 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType2)).getType();
        constraintSystem.addSubtypeConstraint(type3, effectiveExpectedTypeInSystem, position);
    }

    private final <D extends CallableDescriptor> void addConstraintForCallableReference(KtCallableReferenceExpression callableReference, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        KotlinType kotlinType = this.getExpectedTypeForCallableReference(callableReference, constraintSystem, context2, effectiveExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType expectedType2 = kotlinType;
        if (!GenericCandidateResolverKt.access$isApplicableExpectedTypeForCallableReference(expectedType2)) {
            return;
        }
        KotlinType kotlinType2 = this.getResolvedTypeForCallableReference(callableReference, context2, expectedType2, valueArgument);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType resolvedType = kotlinType2;
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"context.call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        constraintSystem.addSubtypeConstraint(resolvedType, typeSubstitutor2 == null ? null : typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT), position);
    }

    private final <D extends CallableDescriptor> KotlinType getExpectedTypeForCallableReference(KtCallableReferenceExpression callableReference, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2, KotlinType effectiveExpectedType) {
        KotlinType substitutedType = constraintSystem.build().getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (substitutedType != null && !TypeUtils.isDontCarePlaceholder(substitutedType)) {
            return substitutedType;
        }
        KotlinType shapeType = this.argumentTypeResolver.getShapeTypeOfCallableReference(callableReference, (CallResolutionContext)context2, false);
        if (shapeType != null && FunctionTypesKt.isFunctionTypeOrSubtype(shapeType) && !CallResolverUtilKt.hasUnknownFunctionParameter(shapeType)) {
            return shapeType;
        }
        return null;
    }

    private final <D extends CallableDescriptor> KotlinType getResolvedTypeForCallableReference(KtCallableReferenceExpression callableReference, CallCandidateResolutionContext<D> context2, KotlinType expectedType2, ValueArgument valueArgument) {
        DataFlowInfo dataFlowInfo = context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.candidateCall.da\u2026ts.getInfo(valueArgument)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        KotlinType expectedTypeWithoutReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType2) ? CallResolverUtilKt.replaceReturnTypeByUnknown(expectedType2) : expectedType2;
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context\n            .rep\u2026xtDependency(INDEPENDENT)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        return this.argumentTypeResolver.getCallableReferenceTypeInfo(callableReference, callableReference, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
    }
}

