/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "doubleColonTokenReference", "Lcom/intellij/psi/PsiElement;", "getDoubleColonTokenReference", "()Lcom/intellij/psi/PsiElement;", "hasQuestionMarks", "", "getHasQuestionMarks", "()Z", "isEmptyLHS", "lhs", "getLhs", "receiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "setReceiverExpression", "", "newReceiverExpression", "psi"})
public abstract class KtDoubleColonExpression
extends KtExpressionImpl {
    public KtDoubleColonExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Nullable
    public final KtExpression getReceiverExpression() {
        PsiElement psiElement = this.getNode().getFirstChildNode().getPsi();
        return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
    }

    public final boolean getHasQuestionMarks() {
        for (ASTNode element : SequencesKt.generateSequence((Object)this.getNode().getFirstChildNode(), (Function1)hasQuestionMarks.1.INSTANCE)) {
            IElementType iElementType = element.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.QUEST)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.COLONCOLON)) continue;
            return false;
        }
        String string2 = Intrinsics.stringPlus((String)"Double colon expression must have '::': ", (Object)this.getText());
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @NotNull
    public final PsiElement getDoubleColonTokenReference() {
        Object t = this.findChildByType(KtTokens.COLONCOLON);
        Intrinsics.checkNotNull(t);
        Object t2 = t;
        return t2;
    }

    @Nullable
    public final PsiElement getLhs() {
        return this.getDoubleColonTokenReference().getPrevSibling();
    }

    public final void setReceiverExpression(@NotNull KtExpression newReceiverExpression) {
        PsiElement psiElement;
        KtExpression oldReceiverExpression;
        Intrinsics.checkNotNullParameter((Object)newReceiverExpression, (String)"newReceiverExpression");
        KtExpression ktExpression = oldReceiverExpression = this.getReceiverExpression();
        PsiElement psiElement2 = psiElement = ktExpression == null ? null : ktExpression.replace(newReceiverExpression);
        if (psiElement == null) {
            this.addBefore(newReceiverExpression, this.getDoubleColonTokenReference());
        }
    }

    public final boolean isEmptyLHS() {
        return this.getLhs() == null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitDoubleColonExpression(this, data);
    }
}

