/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.CapturedTypeFromSubtyping;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.AbstractSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import org.jetbrains.kotlin.resolve.calls.model.DiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.InstantiationOfAbstractClass;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import org.jetbrains.kotlin.resolve.calls.model.NonVarargSpread;
import org.jetbrains.kotlin.resolve.calls.model.NoneCallableReferenceCandidates;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleTypeArgument;
import org.jetbrains.kotlin.resolve.calls.model.SmartCastDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.SuperAsExtensionReceiver;
import org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import org.jetbrains.kotlin.resolve.calls.model.TypeArgument;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.resolve.calls.model.WrongCountOfTypeArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.ExpressionKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleTypeArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.TrackingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\u001d\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J1\u00105\u001a\u00020\u001e\"\u0004\b\u0000\u001062\b\u00107\u001a\u0004\u0018\u0001H62\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u00020\u001e09H\u0002\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020@H\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/DiagnosticReporterByTrackingStrategy;", "Lorg/jetbrains/kotlin/resolve/calls/model/DiagnosticReporter;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "psiKotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "call", "Lorg/jetbrains/kotlin/psi/Call;", "getCall", "()Lorg/jetbrains/kotlin/psi/Call;", "getConstantExpressionEvaluator", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "getContext", "()Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "getDataFlowValueFactory", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "getPsiKotlinCall", "()Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "trace", "Lorg/jetbrains/kotlin/resolve/calls/tower/TrackingBindingTrace;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "getTracingStrategy", "()Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "constraintError", "", "diagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "onCall", "onCallArgument", "callArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "onCallArgumentName", "onCallArgumentSpread", "onCallName", "onCallReceiver", "callReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "onExplicitReceiver", "onTypeArgument", "typeArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "onTypeArguments", "reportConstantTypeMismatch", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintError;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "reportIfNonNull", "T", "element", "report", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "reportSmartCast", "smartCastDiagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/SmartCastDiagnostic;", "reportUnstableSmartCast", "unstableSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/model/UnstableSmartCast;", "frontend"})
public final class DiagnosticReporterByTrackingStrategy
implements DiagnosticReporter {
    private final TrackingBindingTrace trace;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final BasicCallResolutionContext context;
    @NotNull
    private final PSIKotlinCall psiKotlinCall;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    private final TracingStrategy getTracingStrategy() {
        return this.psiKotlinCall.getTracingStrategy();
    }

    private final Call getCall() {
        return this.psiKotlinCall.getPsiCall();
    }

    @Override
    public void onExplicitReceiver(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
    }

    @Override
    public void onCall(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, VisibilityError.class)) {
            this.getTracingStrategy().invisibleMember(this.trace, ((VisibilityError)diagnostic).getInvisibleMember());
        } else if (Intrinsics.areEqual(clazz, NoValueForParameter.class)) {
            this.getTracingStrategy().noValueForParameter(this.trace, ((NoValueForParameter)diagnostic).getParameterDescriptor());
        } else if (Intrinsics.areEqual(clazz, InstantiationOfAbstractClass.class)) {
            this.getTracingStrategy().instantiationOfAbstractClass(this.trace);
        } else if (Intrinsics.areEqual(clazz, AbstractSuperCall.class)) {
            this.getTracingStrategy().abstractSuperCall(this.trace);
        }
    }

    @Override
    public void onTypeArguments(@NotNull KotlinCallDiagnostic diagnostic) {
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        KtElement ktElement2 = this.psiKotlinCall.getPsiCall().getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"psiKotlinCall.psiCall.callElement");
        KtElement psiCallElement = ktElement2;
        if (psiCallElement instanceof KtCallExpression) {
            KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)psiCallElement).getTypeArgumentList();
            ktElement = ktTypeArgumentList != null ? (KtElement)ktTypeArgumentList : (KtElement)((KtCallExpression)psiCallElement).getCalleeExpression();
            if (ktElement == null) {
                ktElement = psiCallElement;
            }
        } else {
            ktElement = psiCallElement;
        }
        KtElement reportElement = ktElement;
        KotlinCallDiagnostic kotlinCallDiagnostic = diagnostic;
        if (kotlinCallDiagnostic instanceof WrongCountOfTypeArguments) {
            int expectedTypeArgumentsCount = ((WrongCountOfTypeArguments)diagnostic).getDescriptor().getTypeParameters().size();
            ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)reportElement), expectedTypeArgumentsCount, ((WrongCountOfTypeArguments)diagnostic).getDescriptor());
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"WRONG_NUMBER_OF_TYPE_ARG\u2026t, diagnostic.descriptor)");
            this.trace.report(parametrizedDiagnostic);
        }
    }

    @Override
    public void onCallName(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
    }

    @Override
    public void onTypeArgument(@NotNull TypeArgument typeArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)typeArgument, (String)"typeArgument");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
    }

    @Override
    public void onCallReceiver(@NotNull SimpleKotlinCallArgument callReceiver, @NotNull KotlinCallDiagnostic diagnostic) {
        KtExpression psiExpression;
        Intrinsics.checkParameterIsNotNull((Object)callReceiver, (String)"callReceiver");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, UnsafeCallError.class)) {
            SimpleKotlinCallArgument simpleKotlinCallArgument = callReceiver;
            if (!(simpleKotlinCallArgument instanceof ReceiverExpressionKotlinCallArgument)) {
                simpleKotlinCallArgument = null;
            }
            ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument = (ReceiverExpressionKotlinCallArgument)simpleKotlinCallArgument;
            boolean implicitInvokeCheck = receiverExpressionKotlinCallArgument != null ? receiverExpressionKotlinCallArgument.isForImplicitInvoke() : false;
            this.getTracingStrategy().unsafeCall(this.trace, callReceiver.getReceiver().getReceiverValue().getType(), implicitInvokeCheck);
        } else if (Intrinsics.areEqual(clazz, SuperAsExtensionReceiver.class) && (psiExpression = NewCallArgumentsKt.getPsiExpression(callReceiver)) instanceof KtSuperExpression) {
            ParametrizedDiagnostic<KtSuperExpression> parametrizedDiagnostic = Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((KtSuperExpression)psiExpression, ((KtSuperExpression)psiExpression).getText());
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"SUPER_CANT_BE_EXTENSION_\u2026sion, psiExpression.text)");
            this.trace.report(parametrizedDiagnostic);
        }
    }

    @Override
    public void onCallArgument(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)callArgument, (String)"callArgument");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, SmartCastDiagnostic.class)) {
            this.reportSmartCast((SmartCastDiagnostic)diagnostic);
        } else if (Intrinsics.areEqual(clazz, UnstableSmartCast.class)) {
            this.reportUnstableSmartCast((UnstableSmartCast)diagnostic);
        } else if (Intrinsics.areEqual(clazz, TooManyArguments.class)) {
            this.reportIfNonNull(NewCallArgumentsKt.getPsiExpression(callArgument), (Function1)new Function1<KtExpression, Unit>(this, diagnostic){
                final /* synthetic */ DiagnosticReporterByTrackingStrategy this$0;
                final /* synthetic */ KotlinCallDiagnostic $diagnostic;

                public final void invoke(@NotNull KtExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    TrackingBindingTrace trackingBindingTrace = DiagnosticReporterByTrackingStrategy.access$getTrace$p(this.this$0);
                    KotlinCallDiagnostic kotlinCallDiagnostic = this.$diagnostic;
                    if (kotlinCallDiagnostic == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.TooManyArguments");
                    }
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.TOO_MANY_ARGUMENTS.on(it, ((TooManyArguments)kotlinCallDiagnostic).getDescriptor());
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"TOO_MANY_ARGUMENTS.on(it\u2026anyArguments).descriptor)");
                    trackingBindingTrace.report(parametrizedDiagnostic);
                }
                {
                    this.this$0 = diagnosticReporterByTrackingStrategy;
                    this.$diagnostic = kotlinCallDiagnostic;
                    super(1);
                }
            });
            this.trace.markAsReported();
        } else if (Intrinsics.areEqual(clazz, VarargArgumentOutsideParentheses.class)) {
            this.reportIfNonNull(NewCallArgumentsKt.getPsiExpression(callArgument), (Function1)new Function1<KtExpression, Unit>(this){
                final /* synthetic */ DiagnosticReporterByTrackingStrategy this$0;

                public final void invoke(@NotNull KtExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    TrackingBindingTrace trackingBindingTrace = DiagnosticReporterByTrackingStrategy.access$getTrace$p(this.this$0);
                    SimpleDiagnostic<KtExpression> simpleDiagnostic = Errors.VARARG_OUTSIDE_PARENTHESES.on((KtExpression)((PsiElement)it));
                    Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"VARARG_OUTSIDE_PARENTHESES.on(it)");
                    trackingBindingTrace.report(simpleDiagnostic);
                }
                {
                    this.this$0 = diagnosticReporterByTrackingStrategy;
                    super(1);
                }
            });
        } else if (Intrinsics.areEqual(clazz, MixingNamedAndPositionArguments.class)) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(NewCallArgumentsKt.getPsiCallArgument(callArgument).getValueArgument().asElement());
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"MIXING_NAMED_AND_POSITIO\u2026alueArgument.asElement())");
            this.trace.report(simpleDiagnostic);
        } else if (Intrinsics.areEqual(clazz, NoneCallableReferenceCandidates.class)) {
            KtExpression $receiver$iv = NewCallArgumentsKt.getPsiExpression(((NoneCallableReferenceCandidates)diagnostic).getArgument());
            KtExpression ktExpression = $receiver$iv;
            if (!(ktExpression instanceof KtCallableReferenceExpression)) {
                ktExpression = null;
            }
            KtCallableReferenceExpression expression2 = (KtCallableReferenceExpression)ktExpression;
            this.reportIfNonNull(expression2, (Function1)new Function1<KtCallableReferenceExpression, Unit>(this){
                final /* synthetic */ DiagnosticReporterByTrackingStrategy this$0;

                public final void invoke(@NotNull KtCallableReferenceExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    TrackingBindingTrace trackingBindingTrace = DiagnosticReporterByTrackingStrategy.access$getTrace$p(this.this$0);
                    ParametrizedDiagnostic<KtReferenceExpression> parametrizedDiagnostic = Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it.getCallableReference()), it.getCallableReference());
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"UNRESOLVED_REFERENCE.on(\u2026ce, it.callableReference)");
                    trackingBindingTrace.report(parametrizedDiagnostic);
                }
                {
                    this.this$0 = diagnosticReporterByTrackingStrategy;
                    super(1);
                }
            });
        }
    }

    private final <T> void reportIfNonNull(T element, Function1<? super T, Unit> report2) {
        if (element != null) {
            report2.invoke(element);
        }
    }

    @Override
    public void onCallArgumentName(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)callArgument, (String)"callArgument");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Object object = NewCallArgumentsKt.getPsiCallArgument(callArgument).getValueArgument().getArgumentName();
        if (object == null || (object = object.getReferenceExpression()) == null) {
            return;
        }
        Object nameReference = object;
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, NamedArgumentReference.class)) {
            this.trace.record(BindingContext.REFERENCE_TARGET, nameReference, ((NamedArgumentReference)diagnostic).getParameterDescriptor());
            this.trace.markAsReported();
        } else if (Intrinsics.areEqual(clazz, NameForAmbiguousParameter.class)) {
            SimpleDiagnostic<KtReferenceExpression> simpleDiagnostic = Errors.NAME_FOR_AMBIGUOUS_PARAMETER.on((KtReferenceExpression)((PsiElement)nameReference));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"NAME_FOR_AMBIGUOUS_PARAMETER.on(nameReference)");
            this.trace.report(simpleDiagnostic);
        } else if (Intrinsics.areEqual(clazz, NameNotFound.class)) {
            ParametrizedDiagnostic<KtReferenceExpression> parametrizedDiagnostic = Errors.NAMED_PARAMETER_NOT_FOUND.on((KtReferenceExpression)((PsiElement)nameReference), (KtReferenceExpression)nameReference);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"NAMED_PARAMETER_NOT_FOUN\u2026Reference, nameReference)");
            this.trace.report(parametrizedDiagnostic);
        } else if (Intrinsics.areEqual(clazz, NamedArgumentNotAllowed.class)) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on((PsiElement)nameReference, ((NamedArgumentNotAllowed)diagnostic).getDescriptor() instanceof FunctionInvokeDescriptor ? Errors.BadNamedArgumentsTarget.INVOKE_ON_FUNCTION_TYPE : Errors.BadNamedArgumentsTarget.NON_KOTLIN_FUNCTION);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"NAMED_ARGUMENTS_NOT_ALLO\u2026UNCTION\n                )");
            this.trace.report(parametrizedDiagnostic);
        } else if (Intrinsics.areEqual(clazz, ArgumentPassedTwice.class)) {
            SimpleDiagnostic<KtReferenceExpression> simpleDiagnostic = Errors.ARGUMENT_PASSED_TWICE.on((KtReferenceExpression)((PsiElement)nameReference));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"ARGUMENT_PASSED_TWICE.on(nameReference)");
            this.trace.report(simpleDiagnostic);
        }
    }

    @Override
    public void onCallArgumentSpread(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)callArgument, (String)"callArgument");
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, NonVarargSpread.class)) {
            Object object;
            KotlinCallArgument $receiver$iv = callArgument;
            KotlinCallArgument kotlinCallArgument = $receiver$iv;
            if (!(kotlinCallArgument instanceof ExpressionKotlinCallArgumentImpl)) {
                kotlinCallArgument = null;
            }
            LeafPsiElement spreadElement = (object = (ExpressionKotlinCallArgumentImpl)kotlinCallArgument) != null && (object = ((ExpressionKotlinCallArgumentImpl)object).getValueArgument()) != null ? object.getSpreadElement() : null;
            this.reportIfNonNull(spreadElement, (Function1)new Function1<LeafPsiElement, Unit>(this){
                final /* synthetic */ DiagnosticReporterByTrackingStrategy this$0;

                public final void invoke(@NotNull LeafPsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    TrackingBindingTrace trackingBindingTrace = DiagnosticReporterByTrackingStrategy.access$getTrace$p(this.this$0);
                    SimpleDiagnostic<LeafPsiElement> simpleDiagnostic = Errors.NON_VARARG_SPREAD.on((LeafPsiElement)((PsiElement)it));
                    Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"NON_VARARG_SPREAD.on(it)");
                    trackingBindingTrace.report(simpleDiagnostic);
                }
                {
                    this.this$0 = diagnosticReporterByTrackingStrategy;
                    super(1);
                }
            });
        }
    }

    private final void reportSmartCast(SmartCastDiagnostic smartCastDiagnostic) {
        NewResolvedCallImpl resolvedCall2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3;
        ResolvedCall<? extends CallableDescriptor> resolvedCall4;
        Object object;
        SmartCastResult smartCastResult2;
        SmartCastResult smartCastResult3;
        ExpressionKotlinCallArgument expressionArgument = smartCastDiagnostic.getArgument();
        ExpressionKotlinCallArgument expressionKotlinCallArgument = expressionArgument;
        if (expressionKotlinCallArgument instanceof ExpressionKotlinCallArgumentImpl) {
            this.trace.markAsReported();
            Object Context2 = this.context.replaceDataFlowInfo(((ExpressionKotlinCallArgumentImpl)expressionArgument).getDataFlowInfoBeforeThisArgument());
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"context.replaceDataFlowI\u2026owInfoBeforeThisArgument)");
            BasicCallResolutionContext context = (BasicCallResolutionContext)Context2;
            KtExpression argumentExpression = KtPsiUtil.getLastElementDeparenthesized(((ExpressionKotlinCallArgumentImpl)expressionArgument).getValueArgument().getArgumentExpression(), context.statementFilter);
            DataFlowValue dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(expressionArgument.getReceiver().getReceiverValue(), context);
            smartCastResult3 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue2, smartCastDiagnostic.getSmartCastType(), argumentExpression, context, this.getCall(), true);
        } else if (expressionKotlinCallArgument instanceof ReceiverExpressionKotlinCallArgument) {
            this.trace.markAsReported();
            ReceiverValue receiverValue = expressionArgument.getReceiver().getReceiverValue();
            DataFlowValue dataFlowValue3 = this.dataFlowValueFactory.createDataFlowValue(receiverValue, this.context);
            KotlinType kotlinType = smartCastDiagnostic.getSmartCastType();
            ReceiverValue receiverValue2 = receiverValue;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
            smartCastResult3 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue3, kotlinType, expressionReceiver != null ? expressionReceiver.getExpression() : null, this.context, this.getCall(), true);
        } else {
            smartCastResult3 = smartCastResult2 = null;
        }
        if ((object = smartCastDiagnostic.getKotlinCall()) != null && (object = PSIKotlinCallsKt.getPsiKotlinCall((KotlinCall)object)) != null && (object = ((PSIKotlinCall)object).getPsiCall()) != null) {
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            resolvedCall4 = CallUtilKt.getResolvedCall((Call)object, bindingContext);
        } else {
            resolvedCall4 = resolvedCall3 = null;
        }
        if (!(resolvedCall4 instanceof NewResolvedCallImpl)) {
            resolvedCall3 = null;
        }
        if ((resolvedCall2 = (NewResolvedCallImpl)resolvedCall3) != null && smartCastResult2 != null) {
            if (Intrinsics.areEqual((Object)resolvedCall2.getExtensionReceiver(), (Object)expressionArgument.getReceiver().getReceiverValue())) {
                resolvedCall2.updateExtensionReceiverWithSmartCastIfNeeded(smartCastResult2.getResultType());
            }
            if (Intrinsics.areEqual((Object)resolvedCall2.getDispatchReceiver(), (Object)expressionArgument.getReceiver().getReceiverValue())) {
                resolvedCall2.setSmartCastDispatchReceiverType(smartCastResult2.getResultType());
            }
        }
    }

    private final void reportUnstableSmartCast(UnstableSmartCast unstableSmartCast) {
        this.reportSmartCast(new SmartCastDiagnostic(unstableSmartCast.getArgument(), unstableSmartCast.getTargetType(), null));
    }

    @Override
    public void constraintError(@NotNull KotlinCallDiagnostic diagnostic) {
        block15: {
            Class<?> clazz;
            block14: {
                ConstraintPosition constraintPosition;
                ConstraintPosition constraintPosition2;
                Object it;
                Object object;
                Object argument;
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                clazz = diagnostic.getClass();
                if (!Intrinsics.areEqual(clazz, NewConstraintError.class)) break block14;
                NewConstraintError constraintError = (NewConstraintError)diagnostic;
                ConstraintPosition position = constraintError.getPosition().getFrom();
                ConstraintPosition constraintPosition3 = position;
                if (!(constraintPosition3 instanceof ArgumentConstraintPosition)) {
                    constraintPosition3 = null;
                }
                if ((object2 = (ArgumentConstraintPosition)constraintPosition3) == null || (object2 = ((ArgumentConstraintPosition)object2).getArgument()) == null) {
                    ConstraintPosition constraintPosition4 = position;
                    if (!(constraintPosition4 instanceof ReceiverConstraintPosition)) {
                        constraintPosition4 = null;
                    }
                    ReceiverConstraintPosition receiverConstraintPosition = (ReceiverConstraintPosition)constraintPosition4;
                    object2 = receiverConstraintPosition != null ? receiverConstraintPosition.getArgument() : null;
                }
                Object object3 = argument = object2;
                if (object3 != null) {
                    it = object = object3;
                    KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression((KotlinCallArgument)it);
                    if (ktExpression == null) {
                        return;
                    }
                    KtExpression expression2 = ktExpression;
                    KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(expression2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"KtPsiUtil.safeDeparenthesize(expression)");
                    KtExpression deparenthesized = ktExpression2;
                    if (this.reportConstantTypeMismatch(constraintError, deparenthesized)) {
                        return;
                    }
                    ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)deparenthesized), constraintError.getUpperType(), constraintError.getLowerType());
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.TYPE_MISMATCH.on(\u2026onstraintError.lowerType)");
                    this.trace.report(parametrizedDiagnostic);
                }
                if (!((constraintPosition2 = position) instanceof ExpectedTypeConstraintPosition)) {
                    constraintPosition2 = null;
                }
                ExpectedTypeConstraintPosition expectedTypeConstraintPosition = (ExpectedTypeConstraintPosition)constraintPosition2;
                if (expectedTypeConstraintPosition != null) {
                    object = expectedTypeConstraintPosition;
                    it = object;
                    KtElement $receiver$iv = PSIKotlinCallsKt.getPsiKotlinCall(((ExpectedTypeConstraintPosition)it).getTopLevelCall()).getPsiCall().getCallElement();
                    KtElement ktElement = $receiver$iv;
                    if (!(ktElement instanceof KtExpression)) {
                        ktElement = null;
                    }
                    KtExpression call2 = (KtExpression)ktElement;
                    this.reportIfNonNull(call2, (Function1)new Function1<KtExpression, Unit>(this, constraintError){
                        final /* synthetic */ DiagnosticReporterByTrackingStrategy this$0;
                        final /* synthetic */ NewConstraintError $constraintError$inlined;
                        {
                            this.this$0 = diagnosticReporterByTrackingStrategy;
                            this.$constraintError$inlined = newConstraintError;
                            super(1);
                        }

                        public final void invoke(@NotNull KtExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            TrackingBindingTrace trackingBindingTrace = DiagnosticReporterByTrackingStrategy.access$getTrace$p(this.this$0);
                            ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)it), this.$constraintError$inlined.getUpperType(), this.$constraintError$inlined.getLowerType());
                            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.TYPE_MISMATCH.on(\u2026onstraintError.lowerType)");
                            trackingBindingTrace.report(parametrizedDiagnostic);
                        }
                    });
                }
                if (!((constraintPosition = position) instanceof ExplicitTypeParameterConstraintPosition)) {
                    constraintPosition = null;
                }
                ExplicitTypeParameterConstraintPosition explicitTypeParameterConstraintPosition = (ExplicitTypeParameterConstraintPosition)constraintPosition;
                if (explicitTypeParameterConstraintPosition == null) break block15;
                it = object = explicitTypeParameterConstraintPosition;
                SimpleTypeArgument simpleTypeArgument = ((ExplicitTypeParameterConstraintPosition)it).getTypeArgument();
                if (simpleTypeArgument == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.SimpleTypeArgumentImpl");
                }
                KtTypeReference typeArgumentReference = ((SimpleTypeArgumentImpl)simpleTypeArgument).getTypeReference();
                ParametrizedDiagnostic<KtTypeReference> parametrizedDiagnostic = Errors.UPPER_BOUND_VIOLATED.on((KtTypeReference)((PsiElement)typeArgumentReference), constraintError.getUpperType(), constraintError.getLowerType());
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"UPPER_BOUND_VIOLATED.on(\u2026onstraintError.lowerType)");
                this.trace.report(parametrizedDiagnostic);
                break block15;
            }
            if (!Intrinsics.areEqual(clazz, CapturedTypeFromSubtyping.class)) break block15;
            CapturedTypeFromSubtyping capturedError = (CapturedTypeFromSubtyping)diagnostic;
            ConstraintPosition constraintPosition = capturedError.getPosition();
            if (!(constraintPosition instanceof ArgumentConstraintPosition)) {
                constraintPosition = null;
            }
            ArgumentConstraintPosition argumentConstraintPosition = (ArgumentConstraintPosition)constraintPosition;
            if (argumentConstraintPosition != null) {
                ArgumentConstraintPosition argumentConstraintPosition2;
                ArgumentConstraintPosition it = argumentConstraintPosition2 = argumentConstraintPosition;
                KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression(it.getArgument());
                if (ktExpression == null) {
                    return;
                }
                KtExpression expression3 = ktExpression;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.NEW_INFERENCE_ERROR.on(expression3, "Capture type from subtyping " + capturedError.getConstraintType() + " for variable " + capturedError.getTypeVariable());
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"NEW_INFERENCE_ERROR.on(\n\u2026                        )");
                this.trace.report(parametrizedDiagnostic);
            }
        }
    }

    private final boolean reportConstantTypeMismatch(NewConstraintError constraintError, KtExpression expression2) {
        if (expression2 instanceof KtConstantExpression) {
            ModuleDescriptor module2 = DescriptorUtilsKt.getModule(this.context.scope.getOwnerDescriptor());
            BindingTrace bindingTrace = this.trace;
            KotlinType kotlinType = this.context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.expectedType");
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression2, bindingTrace, kotlinType);
            boolean hasConstantTypeError = new CompileTimeConstantChecker(this.context, module2, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression2, constraintError.getUpperType());
            if (hasConstantTypeError) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final ConstantExpressionEvaluator getConstantExpressionEvaluator() {
        return this.constantExpressionEvaluator;
    }

    @NotNull
    public final BasicCallResolutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final PSIKotlinCall getPsiKotlinCall() {
        return this.psiKotlinCall;
    }

    @NotNull
    public final DataFlowValueFactory getDataFlowValueFactory() {
        return this.dataFlowValueFactory;
    }

    public DiagnosticReporterByTrackingStrategy(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BasicCallResolutionContext context, @NotNull PSIKotlinCall psiKotlinCall, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)psiKotlinCall, (String)"psiKotlinCall");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.context = context;
        this.psiKotlinCall = psiKotlinCall;
        this.dataFlowValueFactory = dataFlowValueFactory;
        BindingTrace bindingTrace = this.context.trace;
        if (bindingTrace == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.TrackingBindingTrace");
        }
        this.trace = (TrackingBindingTrace)bindingTrace;
    }

    @NotNull
    public static final /* synthetic */ TrackingBindingTrace access$getTrace$p(DiagnosticReporterByTrackingStrategy $this) {
        return $this.trace;
    }
}

