/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.util.CDIHelper;
import org.drools.core.util.StringUtils;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;

public class KModuleRegisterableItemsFactory
extends DefaultRegisterableItemsFactory {
    private static final String DEFAULT_KIE_SESSION = "defaultKieSession";
    private KieContainer kieContainer;
    private String ksessionName;

    public KModuleRegisterableItemsFactory(KieContainer kieContainer, String ksessionName) {
        this.kieContainer = kieContainer;
        this.ksessionName = ksessionName;
    }

    public KModuleRegisterableItemsFactory(KieContainer kieContainer, String ksessionName, AuditEventBuilder auditBuilder) {
        this.kieContainer = kieContainer;
        this.ksessionName = ksessionName;
        this.setAuditBuilder(auditBuilder);
    }

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        KieSessionModel ksessionModel = null;
        if (StringUtils.isEmpty((CharSequence)this.ksessionName)) {
            ksessionModel = ((KieContainerImpl)this.kieContainer).getKieProject().getDefaultKieSession();
            if (ksessionModel == null) {
                this.ksessionName = DEFAULT_KIE_SESSION;
                ksessionModel = ((KieContainerImpl)this.kieContainer).getKieSessionModel(this.ksessionName);
            }
        } else {
            ksessionModel = ((KieContainerImpl)this.kieContainer).getKieSessionModel(this.ksessionName);
        }
        if (ksessionModel == null) {
            throw new IllegalStateException("Cannot find ksession with name " + this.ksessionName);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ksession", runtime.getKieSession());
        parameters.put("taskService", runtime.getKieSession());
        parameters.put("runtimeManager", ((RuntimeEngineImpl)runtime).getManager());
        try {
            CDIHelper.wireListnersAndWIHs((KieSessionModel)ksessionModel, (KieSession)runtime.getKieSession(), parameters);
        }
        catch (Exception e) {
            CDIHelper.wireListnersAndWIHs((KieSessionModel)ksessionModel, (KieSession)runtime.getKieSession());
        }
        return super.getWorkItemHandlers(runtime);
    }

    @Override
    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        return super.getProcessEventListeners(runtime);
    }

    @Override
    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        return super.getAgendaEventListeners(runtime);
    }

    @Override
    public List<WorkingMemoryEventListener> getWorkingMemoryEventListeners(RuntimeEngine runtime) {
        return super.getWorkingMemoryEventListeners(runtime);
    }
}

