/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.util.ClassLoaderUtil;

public class FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog((Class)FieldInstantiator.class);

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = this.newInstance(clazz);
        if (configuration != null && !"".equals(configuration)) {
            Element configurationElement = this.parseConfiguration(configuration);
            Iterator iter = configurationElement.elements().iterator();
            while (iter.hasNext()) {
                Element propertyElement = (Element)iter.next();
                String propertyName = propertyElement.getName();
                this.setPropertyValue(clazz, newInstance, propertyName, propertyElement);
            }
        }
        return newInstance;
    }

    protected void setPropertyValue(Class clazz, Object newInstance, String propertyName, Element propertyElement) {
        try {
            Field f = this.findField(clazz, propertyName);
            f.setAccessible(true);
            f.set(newInstance, FieldInstantiator.getValue(f.getType(), propertyElement));
        }
        catch (Exception e) {
            log.error((Object)("couldn't parse set field '" + propertyName + "' to value '" + propertyElement.asXML() + "'"), (Throwable)e);
        }
    }

    private Field findField(Class clazz, String propertyName) throws NoSuchFieldException {
        Field f = null;
        if (clazz != null) {
            try {
                f = clazz.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException e) {
                f = this.findField(clazz.getSuperclass(), propertyName);
            }
        }
        return f;
    }

    protected Element parseConfiguration(String configuration) {
        Element element = null;
        try {
            element = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
        }
        catch (DocumentException e) {
            log.error((Object)("couldn't parse bean configuration : " + configuration), (Throwable)e);
            throw new JbpmException(e);
        }
        return element;
    }

    protected Object newInstance(Class clazz) {
        Object newInstance = null;
        try {
            newInstance = clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("couldn't instantiate type '" + clazz.getName() + "' with the default constructor"));
            throw new JbpmException(e);
        }
        return newInstance;
    }

    public static Object getValue(Class type, Element propertyElement) {
        Object value = null;
        try {
            if (type == String.class) {
                value = propertyElement.getText();
            } else if (type == Integer.class || type == Integer.TYPE) {
                value = new Integer(propertyElement.getTextTrim());
            } else if (type == Long.class || type == Long.TYPE) {
                value = new Long(propertyElement.getTextTrim());
            } else if (type == Float.class || type == Float.TYPE) {
                value = new Float(propertyElement.getTextTrim());
            } else if (type == Double.class || type == Double.TYPE) {
                value = new Double(propertyElement.getTextTrim());
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                value = Boolean.valueOf(propertyElement.getTextTrim());
            } else if (type == Character.class || type == Character.TYPE) {
                value = new Character(propertyElement.getTextTrim().charAt(0));
            } else if (type == Short.class || type == Short.TYPE) {
                value = new Short(propertyElement.getTextTrim());
            } else if (type == Byte.class || type == Byte.TYPE) {
                value = new Byte(propertyElement.getTextTrim());
            } else if (List.class.isAssignableFrom(type)) {
                value = FieldInstantiator.getCollection(propertyElement, new ArrayList());
            } else if (Set.class.isAssignableFrom(type)) {
                value = FieldInstantiator.getCollection(propertyElement, new HashSet());
            } else if (Collection.class.isAssignableFrom(type)) {
                value = FieldInstantiator.getCollection(propertyElement, new ArrayList());
            } else if (Map.class.isAssignableFrom(type)) {
                value = FieldInstantiator.getMap(propertyElement, new HashMap());
            } else if (Element.class.isAssignableFrom(type)) {
                value = propertyElement;
            } else {
                Constructor constructor = type.getConstructor(String.class);
                if (propertyElement.isTextOnly() && constructor != null) {
                    value = constructor.newInstance(propertyElement.getTextTrim());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("couldn't parse the bean property value '" + propertyElement.asXML() + "' to a '" + type.getName() + "'"));
            throw new JbpmException(e);
        }
        return value;
    }

    static Object getMap(Element mapElement, Map map) {
        Class keyClass = String.class;
        String keyType = mapElement.attributeValue("key-type");
        if (keyType != null) {
            keyClass = ClassLoaderUtil.loadClass(keyType);
        }
        Class valueClass = String.class;
        String valueType = mapElement.attributeValue("value-type");
        if (valueType != null) {
            valueClass = ClassLoaderUtil.loadClass(valueType);
        }
        Iterator iter = mapElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            Element keyElement = element.element("key");
            Element valueElement = element.element("value");
            map.put(FieldInstantiator.getValue(keyClass, keyElement), FieldInstantiator.getValue(valueClass, valueElement));
        }
        return map;
    }

    static Object getCollection(Element collectionElement, Collection collection) {
        Class elementClass = String.class;
        String elementType = collectionElement.attributeValue("element-type");
        if (elementType != null) {
            elementClass = ClassLoaderUtil.loadClass(elementType);
        }
        Iterator iter = collectionElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            collection.add(FieldInstantiator.getValue(elementClass, element));
        }
        return collection;
    }
}

