/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class TaskInstanceEndCommand
implements Command {
    private static final long serialVersionUID = 5721341060757950369L;
    private long taskInstanceId = 0L;
    private String transitionName = null;
    private Map variables;
    private TaskInstance previoustaskInstance = null;

    public TaskInstanceEndCommand() {
    }

    public TaskInstanceEndCommand(long taskInstanceId, String transitionName) {
        this.taskInstanceId = taskInstanceId;
        this.transitionName = transitionName;
    }

    public TaskInstanceEndCommand(long taskInstanceId, String transitionName, Map variables) {
        this.taskInstanceId = taskInstanceId;
        this.transitionName = transitionName;
        this.variables = variables;
    }

    public Object execute(JbpmContext jbpmContext) {
        TaskInstance taskInstance = this.getTaskInstance(jbpmContext);
        if (this.variables != null && this.variables.size() > 0) {
            taskInstance.getContextInstance().addVariables(this.variables);
        }
        if (this.transitionName == null) {
            taskInstance.end();
        } else {
            taskInstance.end(this.transitionName);
        }
        return taskInstance;
    }

    protected TaskInstance getTaskInstance(JbpmContext jbpmContext) {
        if (this.previoustaskInstance != null) {
            return this.previoustaskInstance;
        }
        return jbpmContext.getTaskInstance(this.taskInstanceId);
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }
}

