/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.SuspendableChannel;
import org.xnio.channels.WrappedChannel;

public abstract class TranslatingSuspendableChannel<C extends SuspendableChannel, W extends SuspendableChannel>
implements SuspendableChannel,
WrappedChannel<W> {
    protected final W channel;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();
    private boolean readsRequested;
    private boolean writesRequested;
    private final Runnable readListenerCommand = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean doReads;
            do {
                Object object = TranslatingSuspendableChannel.this.getReadLock();
                synchronized (object) {
                    if (TranslatingSuspendableChannel.this.isReadable() == Readiness.NEVER) {
                        return;
                    }
                }
                ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this.channel, TranslatingSuspendableChannel.this.readListener);
                object = TranslatingSuspendableChannel.this.getReadLock();
                synchronized (object) {
                    Readiness readiness = TranslatingSuspendableChannel.this.isReadable();
                    boolean bl = doReads = TranslatingSuspendableChannel.this.readsRequested && readiness == Readiness.ALWAYS;
                    if (readiness == Readiness.NEVER) {
                        TranslatingSuspendableChannel.this.channel.suspendReads();
                    }
                }
            } while (doReads);
        }

        public String toString() {
            return "Read listener command for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<W> readListener = new ChannelListener<W>(){

        @Override
        public void handleEvent(W channel) {
            TranslatingSuspendableChannel.this.handleReadable(channel);
        }

        public String toString() {
            return "Read listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final Runnable writeListenerCommand = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean doWrites;
            do {
                ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this.channel, TranslatingSuspendableChannel.this.writeListener);
                Object object = TranslatingSuspendableChannel.this.getWriteLock();
                synchronized (object) {
                    Readiness readiness = TranslatingSuspendableChannel.this.isWritable();
                    boolean bl = doWrites = TranslatingSuspendableChannel.this.writesRequested && readiness == Readiness.ALWAYS;
                    if (readiness == Readiness.NEVER) {
                        TranslatingSuspendableChannel.this.channel.suspendWrites();
                    }
                }
            } while (doWrites);
        }

        public String toString() {
            return "Write listener command for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<W> writeListener = new ChannelListener<W>(){

        @Override
        public void handleEvent(W channel) {
            TranslatingSuspendableChannel.this.handleWritable(channel);
        }

        public String toString() {
            return "Write listener for " + TranslatingSuspendableChannel.this;
        }
    };
    private final ChannelListener<W> closeListener = new ChannelListener<W>(){

        @Override
        public void handleEvent(W channel) {
            ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this.thisTyped(), TranslatingSuspendableChannel.this.closeSetter.get());
        }

        public String toString() {
            return "Close listener for " + TranslatingSuspendableChannel.this;
        }
    };

    protected TranslatingSuspendableChannel(W channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.channel = channel;
        ChannelListener.Setter<? extends SuspendableChannel> readSetter = channel.getReadSetter();
        readSetter.set(this.readListener);
        ChannelListener.Setter<? extends SuspendableChannel> writeSetter = channel.getWriteSetter();
        writeSetter.set(this.writeListener);
        ChannelListener.Setter<? extends SuspendableChannel> setter = channel.getCloseSetter();
        setter.set(this.closeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReadable(W channel) {
        ChannelListener<C> listener = this.readSetter.get();
        if (listener == null) {
            Object object = this.getReadLock();
            synchronized (object) {
                channel.suspendReads();
                this.readsRequested = false;
            }
            return;
        }
        ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWritable(W channel) {
        ChannelListener<C> listener = this.writeSetter.get();
        if (listener == null) {
            Object object = this.getWriteLock();
            synchronized (object) {
                channel.suspendWrites();
                this.writesRequested = false;
            }
            return;
        }
        ChannelListeners.invokeChannelListener(this.thisTyped(), listener);
    }

    protected final C thisTyped() {
        return (C)this;
    }

    public ChannelListener.Setter<C> getCloseSetter() {
        return this.closeSetter;
    }

    public ChannelListener.Setter<C> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<C> getWriteSetter() {
        return this.writeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReads() {
        Object object = this.getReadLock();
        synchronized (object) {
            this.readsRequested = false;
            this.channel.suspendReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReads() {
        Object object = this.getReadLock();
        synchronized (object) {
            this.readsRequested = true;
            switch (this.isReadable()) {
                case NEVER: {
                    this.channel.suspendReads();
                    break;
                }
                case OKAY: {
                    this.channel.resumeReads();
                    break;
                }
                case ALWAYS: {
                    this.channel.wakeupReads();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadResumed() {
        Object object = this.getReadLock();
        synchronized (object) {
            return this.readsRequested;
        }
    }

    @Override
    public void wakeupReads() {
        this.resumeReads();
        this.channel.wakeupReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupReadsIfRequested() {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.readsRequested) {
                this.channel.wakeupReads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeReadsIfRequested() {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.readsRequested) {
                this.channel.resumeReads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeReadsIfRequestedAndSuspendWrites() {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.readsRequested) {
                this.channel.resumeReads();
                this.channel.suspendWrites();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendWrites() {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.writesRequested = false;
            this.channel.suspendWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWrites() {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.writesRequested = true;
            switch (this.isWritable()) {
                case NEVER: {
                    this.channel.suspendWrites();
                    break;
                }
                case OKAY: {
                    this.channel.resumeWrites();
                    break;
                }
                case ALWAYS: {
                    this.channel.wakeupWrites();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWriteResumed() {
        Object object = this.getWriteLock();
        synchronized (object) {
            return this.writesRequested;
        }
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites();
        this.channel.wakeupWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupWritesIfRequested() {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.writesRequested) {
                this.channel.wakeupWrites();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeWritesIfRequested() {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.writesRequested) {
                this.channel.resumeWrites();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeWritesIfRequestedAndSuspendReads() {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.writesRequested) {
                this.channel.resumeWrites();
                this.channel.suspendReads();
            }
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public boolean flush() throws IOException {
        return this.channel.flush();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    @Override
    public boolean shutdownWrites() throws IOException {
        return this.channel.shutdownWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.isReadable() == Readiness.ALWAYS) {
                return;
            }
        }
        this.channel.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.isReadable() == Readiness.ALWAYS) {
                return;
            }
        }
        this.channel.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.isWritable() == Readiness.ALWAYS) {
                return;
            }
        }
        this.channel.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.isWritable() == Readiness.ALWAYS) {
                return;
            }
        }
        this.channel.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.channel.getWriteThread();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public W getChannel() {
        return this.channel;
    }

    protected abstract Readiness isReadable();

    protected abstract Object getReadLock();

    protected abstract Readiness isWritable();

    protected abstract Object getWriteLock();

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public String toString() {
        return this.getClass().getName() + " around " + this.channel;
    }

    protected static enum Readiness {
        ALWAYS,
        OKAY,
        NEVER;

    }
}

